# coding: utf-8
from sandbox.projects.avia import verify_log
from sandbox import sdk2


class AviaVerifyReviseLog(verify_log.AviaAbstractVerifyLogTask):
    _invalid_log_records_query = """ -- запрос для получения невалидных записей в логе
        DECLARE $table_path AS String;
        DECLARE $table_start_date AS String;
        DECLARE $table_finish_date AS String;

        SELECT
            *
        FROM
            range($table_path, $table_start_date, $table_finish_date)
        WHERE
            price is NULL
            OR shown_price is NULL
            OR (
                price_revise is NULL
                AND result NOT IN ("can_not_fetch_review_error", "can_not_fetch_price_error", "ticket_changed")
            )
    """

    class Parameters(verify_log.AviaAbstractVerifyLogTask.Parameters):
        with sdk2.parameters.Group('Logs settings') as logs_settings:
            logs_path = sdk2.parameters.String(
                'Logs path',
                required=True,
                default='//logs/avia-revise-log/30min',
            )
