# coding: utf8
from sandbox import sdk2
from sandbox.projects.Travel.resources.dicts import TRAVEL_DICT_AVIA_BASE


class AVIA_IBM_MQ_CLIENT_DIST(sdk2.Resource):
    version = sdk2.parameters.String('Client version')
    releasable = False
    executable = False
    auto_backup = True


class AVIA_WIZARD_DIRECTION_NATIONAL(TRAVEL_DICT_AVIA_BASE):
    """Справочник национальных направлений"""
    resource_name = 'direction_national'
    is_common_dict = True


class AVIA_WIZARD_MIN_PRICE(TRAVEL_DICT_AVIA_BASE):
    """Минимальные цены по направлениям"""
    resource_name = 'min_price'
    is_common_dict = True


class AVIA_WIZARD_ROUTE_COUNT(TRAVEL_DICT_AVIA_BASE):
    """Количество перелетов по маршруту"""
    resource_name = 'route_count'
    is_common_dict = True


class AVIA_WIZARD_SETTLEMENT_NATIONAL(TRAVEL_DICT_AVIA_BASE):
    """Справочник населённых пунктов по странам"""
    resource_name = 'settlement_national'
    is_common_dict = True


class AVIA_MYSQL_SCHEMA_DUMP(sdk2.Resource):
    releasable = True
    executable = False
    auto_backup = True


class AVIA_MYSQL_PACKAGE(sdk2.Resource):
    """В ресурсе лежит пакет mysql"""
    releasable = True
    executable = False
    auto_backup = False


class TRAVEL_NOTIFIER_API_PACKAGE(sdk2.Resource):
    """Ресурс с архивом полученным в результате сборки /travel/notifier"""
    executable = False
    releasable = True


class TRAVEL_NOTIFIER_PROCESSOR_PACKAGE(sdk2.Resource):
    """Ресурс с архивом полученным в результате сборки /travel/notifier-processor"""
    executable = False
    releasable = True


class TRAVEL_NOTIFIER_COLLECTOR_PACKAGE(sdk2.Resource):
    """Ресурс с архивом полученным в результате сборки /travel/notifier-collector"""
    executable = False
    releasable = True


class AVIA_CHATBOT_PACKAGE(sdk2.Resource):
    """Ресурс с архивом полученным в результате сборки /travel/avia/chatbot"""
    executable = False
    releasable = True


class AVIA_AD_FEED_BUNDLE(sdk2.Resource):

    releasable = True
    releasers = ["permyakovnik", "ilyaturuntaev", "robot-srch-releaser"]


class AVIA_HOTELS_REFERENCE(sdk2.Resource):
    executable = False
    releasable = True


class AVIA_PARTNER_CONVERSIONS(sdk2.Resource):
    resource_name = 'partner_conversions'
    executable = False
    releasable = True
