# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.common.build.YaMake import YaMakeTask
import sandbox.projects.common.build.parameters as build_params


class AWACS_CTL_LINUX(sdk2.Resource):
    """ Linux версия CLI для управления AWACS балансерами """
    auto_backup = True
    releasable = True
    executable = True
    releasers = ['keepclean', 'romanovich', 'moridin']


class AWACS_CTL_MACOS(AWACS_CTL_LINUX):
    """ MacOS версия CLI для управления AWACS балансерами """


class BuildAwacsCtlBinary(YaMakeTask):
    """ Build Awacs Ctl binary """
    type = 'BUILD_AWACS_CTL_BINARY'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.TargetPlatformFlags
    ]

    def get_targets(self):
        return ['infra/awacs/awacsctl2/bin']

    def get_resources(self):
        target_platform_flags = self.get_target_platform_flags()
        is_darwin = False
        if 'darwin' in target_platform_flags:
            is_darwin = True

        return {
            'awacsctl2': {
                'description': '{} version of AwacsCtl for control awacs-balancers'.format(
                    'MacOS' if is_darwin else 'Linux'
                ),
                'resource_type': AWACS_CTL_MACOS if is_darwin else AWACS_CTL_LINUX,
                'resource_path': 'awacsctl2/bin/awacsctl2',
                'arch': 'darwin' if is_darwin else 'linux'
            }
        }

    def get_arts(self):
        return [
            {
                'path': 'infra/awacs/awacsctl2/bin',
                'dest': 'awacsctl2'
            }
        ]


__Task__ = BuildAwacsCtlBinary
