# coding: utf-8

import logging
import json

from sandbox import sdk2
from sandbox.projects.balance.resources import BalanceReleaseInfo


class MarkDeployedBalanceReleaseProd(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 8192  # 8GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        st_ticket = sdk2.parameters.String(
            "Startrek ticket",
        )
        version = sdk2.parameters.String(
            "Deployed version"
        )
        release_timestamp = sdk2.parameters.Integer(
            "Release timestamp",
            required=True,
        )

    def on_execute(self):
        file_resource_data = sdk2.ResourceData(
            BalanceReleaseInfo(self, self.Parameters.description, "deploy-info.json")
        )
        logging.info("Dumping json to a file")
        with file_resource_data.path.open("wb") as f:
            json.dump(
                {
                    "version": self.Parameters.version,
                    "timestamp": self.Parameters.release_timestamp,
                    "st_ticket": self.Parameters.st_ticket,
                    "debug": True,
                },
                f,
            )
