# coding: utf-8

import logging
import json
import requests
import datetime
import time

from sandbox import sdk2


VAULT_OWNER = "BILLING-CI"
VAULT_NAME = "infra_token_robot_billing_ci"
INFRA_URL = 'https://infra-api.yandex-team.ru/v1/'


class EventUpdateException(BaseException):
    pass


class ResolveInfraEvent(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 8192  # 8GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        event_id = sdk2.parameters.Integer(
            "Event id",
            required=True,
        )

        finish_time = sdk2.parameters.String(
            "Finish time (YYYY-MM-DD HH24:MI:SS)",
        )

    def on_execute(self):

        def cast_dt(input):
            DT_FORMAT = '%Y-%m-%d %H:%M:%S'
            if input:
                return time.mktime((datetime.datetime.strptime(input, DT_FORMAT)).timetuple())
            return input

        infra_token = sdk2.Vault.data(VAULT_OWNER, VAULT_NAME)

        headers = {
            'Authorization': 'OAuth {}'.format(infra_token),
            'Content-Type': 'application/json',
        }

        finish_time = cast_dt(self.Parameters.finish_time) or time.mktime(datetime.datetime.now().timetuple())

        data = {
            "finishTime": finish_time,
        }

        logging.info("request data: {}".format(json.dumps(data)))

        response = requests.put(INFRA_URL + 'events/' + '{}'.format(self.Parameters.event_id),
                                data=json.dumps(data),
                                headers=headers,
                                verify=False)

        if response.status_code == 200:
            return
        else:
            raise EventUpdateException('Response status code: {}'.format(response.status_code))
