# coding: utf-8
from sandbox import sdk2
from sandbox.projects.common.build.YaPackage import YaPackageResource
from sandbox.projects.resource_types import search_priemka_releasers


class BalanceMediumBinary(sdk2.Resource):
    """
        Balance medium servant binary
    """
    any_arch = False
    releasable = True
    releasers = search_priemka_releasers + ["robot-testenv"]
    auto_backup = True
    arcadia_build_path = 'junk/igogor/balance-code/tools/bin/balance-medium'


class BalanceYaPackage(YaPackageResource):
    """
        Balancе package created by YA_PACKAGE
    """
    pass


class BalanceAssessorsYaPackage(YaPackageResource):
    """
        Balance assessors package created by YA_PACKAGE
    """
    pass


class SnoutProxyYaPackage(YaPackageResource):
    """
        Snout Proxy package created by YA_PACKAGE
    """
    pass


class ToolsMinimalisticYaPackage(YaPackageResource):
    """
        yb-tools-minimalistic package created by YA_PACKAGE
    """
    pass


class BalanceLiquibaseBeforeYaPackage(YaPackageResource):
    """
        yb-liquibase-full-before package created by YA_PACKAGE
    """


class BalanceLiquibaseAfterYaPackage(YaPackageResource):
    """
        yb-liquibase-full-after package created by YA_PACKAGE
    """


class BalanceReleaseInfo(sdk2.Resource):
    """
        Information about production release
    """
    pass


class BalanceWkHtmlToImageBinary(sdk2.Resource):
    pass


class BalanceWkHtmlToPdfBinary(sdk2.Resource):
    pass


class BalanceWkHtmlToPdfYaPackage(sdk2.Resource):
    """
        yb-wkhtmltopdf package created by YA_PACKAGE
    """
    pass


class BalanceMailTemplatesYaPackage(sdk2.Resource):
    """
        yb-mail-templates package created by YA_PACKAGE
    """
    pass
