# -*- coding: utf-8 -*-

import os
import requests
import netaddr

from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia


class TrustedNetworksUpdater(sdk2.Task):
    '''
    Update trusted networks IPs list
    '''
    HBF_PATH = 'https://hbf.yandex.net/macros/'
    ALL_NETS = '_YANDEXNETS_'
    UNTRUSTED_NETS = '_SPIDERTUN64_'
    FOLDER_PATH = 'arcadia:/arc/trunk/arcadia/gencfg/custom_generators/balancer_gencfg/src'
    FILE_NAME = 'trusted_nets.py'

    def on_execute(self):
        local_path = os.path.abspath('local')
        Arcadia.checkout(self.FOLDER_PATH, local_path)

        file_path = os.path.join(local_path, self.FILE_NAME)

        all_nets = requests.get(os.path.join(self.HBF_PATH, self.ALL_NETS)).json()
        trusted_nets = netaddr.IPSet(all_nets)

        untrusted_nets = requests.get(os.path.join(self.HBF_PATH, self.UNTRUSTED_NETS)).json()
        trusted_nets -= netaddr.IPSet(untrusted_nets)

        output = str(str.join(',', map(str, trusted_nets.iter_cidrs())).strip())
        with open(file_path, 'w') as f:
            f.write('TRUSTED_NETS = \'{}\'  # noqa\n'.format(output))

        diff = Arcadia.diff(file_path)
        if diff:
            self.set_info('Diff:\n{}'.format(diff))

            self.set_info('Commiting...')
            Arcadia.commit(
                file_path,
                'MINOTAUR-762: Updated trusted_nets.py.',
                user='zomb-sandbox-rw'
            )
            self.set_info('Commited successfully')
        else:
            self.set_info('There are no changes to commit')
