# -*- coding: utf-8 -*-

import logging
import os
import requests

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.common import binary_task

YASTATIC_NAMESPACE = "yastatic.net"


class UpdateYastaticWikiPanels(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Update wiki page with links to yastatic panels
    """

    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)
        with sdk2.parameters.Group("AWACS token") as awacs_token_parameters_block:
            awacs_token_vault_owner = sdk2.parameters.String(
                "AWACS tokent vault owner",
                default=None,
            )
            awacs_token_vault_name = sdk2.parameters.String(
                "AWACS tokent vault name",
                required=True,
            )

        with sdk2.parameters.Group("WIKI token") as wiki_token_parameters_block:
            wiki_token_vault_owner = sdk2.parameters.String(
                "WIKI tokent vault owner",
                default=None,
            )
            wiki_token_vault_name = sdk2.parameters.String(
                "WIKI tokent vault name",
                required=True,
            )


    def on_execute(self):
        binary_task.LastBinaryTaskRelease.on_execute(self)

        from balancer.production.yastatic.yasm import ProcessWiki

        awacs_token = sdk2.Vault.data(self.Parameters.awacs_token_vault_owner, self.Parameters.awacs_token_vault_name)
        wiki_token = sdk2.Vault.data(self.Parameters.wiki_token_vault_owner, self.Parameters.wiki_token_vault_name)

        root_dir = os.getcwd()
        logging.info('root dir is {}'.format(root_dir))
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("awacsctl")) as pl:
            # get latest awacsctl module
            retcode = sp.Popen("curl -vOJ https://proxy.sandbox.yandex-team.ru/last/AWACS_CTL_LINUX && chmod +x awacsctl2", shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
            if retcode != 0:
                raise common.errors.TaskFailure("Error loading awacsctl2")
            # test awacsctl
            logging.info('Home dir is {}'.format(os.environ['HOME']))
            with open('{}/.awacsctl.cfg'.format(os.environ['HOME']), 'w') as cfg_file:
                cfg_file.write("awacs_url: 'https://awacs.yandex-team.ru/'\nawacs_token: {}".format(awacs_token))
            retcode = sp.Popen("{}/awacsctl2 --version".format(root_dir), shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
            if retcode != 0:
                raise common.errors.TaskFailure("Error getting awacsctl2 version")

            logging.info('Clone awacs-ns: {}'.format(YASTATIC_NAMESPACE))
            retcode = self.awacsctl_clone(root_dir, pl, YASTATIC_NAMESPACE)

            if retcode != 0:
                raise common.errors.TaskFailure("Error getting namespace {}".format(YASTATIC_NAMESPACE))

        logging.info("Running awacs parser")

        ProcessWiki(os.path.join(root_dir, "./yastatic.net/upstreams"), wiki_token)

    def on_finish(self, prev_status, status):
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("awacsctl")) as pl:
            sp.Popen("rm ./awacsctl2", shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()

    def awacsctl_clone(self, root_dir, pl, ns):
        return sp.Popen("{}/awacsctl2 clone {}".format(root_dir, ns), shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()

