import json
import logging
import StringIO
import tarfile
import time

from sandbox import sdk2
from sandbox.projects.balancer.load.common import request
from sandbox.projects.tank.load_resources import resources as tank_resources


class BalancerLoadShootViaTankapi(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        tank = sdk2.parameters.String('tank', required=True)
        config = sdk2.parameters.String('config', required=True, multiline=True)
        ammo = sdk2.parameters.String('ammo', multiline=True)

        with sdk2.parameters.Output:
            lunapark_id = sdk2.parameters.Integer('lunapark_id')

    def on_execute(self):
        tank = self.Parameters.tank

        while True:
            res = request('http://{tank}/api/v1/tank/status.json'.format(tank=tank)).text
            logging.debug('tank status {}'.format(res))
            res = json.loads(res)

            if not (res['is_preparing'] or res['is_testing']):
                break

            logging.debug('tank busy')
            time.sleep(10)

        shooting_files = {'load.conf': self.Parameters.config}
        if self.Parameters.ammo:
            shooting_files['ammo'] = self.Parameters.ammo

        res = request('http://{tank}/api/v1/tests/start.json'.format(tank=tank), files=shooting_files).text
        logging.debug('tank start status {}'.format(res))
        res = json.loads(res)
        shooting_id = res['id']

        lunapark_id = None
        while True:
            res = request('http://{tank}/api/v1/tests/{shooting_id}/status.json'.format(tank=tank, shooting_id=shooting_id)).text
            logging.debug('shooting status {}'.format(res))
            res = json.loads(res)

            if lunapark_id is None and res['lunapark_id']:
                lunapark_id = res['lunapark_id']
                self.Parameters.lunapark_id = lunapark_id
                self.set_info('Lunapark link: <a href="https://lunapark.yandex-team.ru/{0}">{0}</a>'.format(lunapark_id), do_escape=False)

            if res['status_code'] == 'FINISHED':
                break

            time.sleep(10)

        res = request('http://{tank}/api/v1/tests/{shooting_id}/logs.json'.format(tank=tank, shooting_id=shooting_id)).text
        logging.debug('tank logs {}'.format(res))
        res = json.loads(res)

        with tarfile.open('logs.tar.gz', 'w:gz') as archive:
            for file in res['files']:
                content = request(
                    'http://{tank}/api/v1/tests/{shooting_id}/logs/{file}'.format(tank=tank, shooting_id=shooting_id, file=file)
                ).content
                tarinfo = tarfile.TarInfo(file)
                tarinfo.size = len(content)
                archive.addfile(tarinfo, StringIO.StringIO(content))

        tank_resources.YANDEX_TANK_LOGS(
            self,
            'Yandex tank logs',
            'logs.tar.gz',
        )
