import requests
import logging
import time

from sandbox import sdk2


def request(url, method=None, headers=None, data=None, files=None, session=requests.Session()):
    for retry in xrange(5):
        try:
            if method is None:
                method = 'POST' if data or files else 'GET'
            r = session.request(
                method=method,
                url=url,
                headers=headers,
                data=data if data else None,
                files=files if files else None,
                verify='/etc/ssl/certs/ca-certificates.crt',
            )
            r.raise_for_status()
            return r
        except requests.exceptions.RequestException as e:
            logging.debug('request {0} exception {1.__class__.__module__}.{1.__class__.__name__}: {1}'.format(url, e))
            time.sleep(1)
    else:
        raise


class BalancerLoadCommonParameters1(sdk2.Task.Parameters):
    with sdk2.parameters.RadioGroup('target') as target:
        target.values['balancer_load_target'] = target.Value('balancer_load_target', default=True)
        target.values['balancer_load_target_testing'] = target.Value('balancer_load_target_testing')
    with sdk2.parameters.RadioGroup('tank') as tank:
        tank.values['tank1'] = tank.Value('tank1', default=True)
        tank.values['tank2'] = tank.Value('tank2')


class BalancerLoadCommonParameters2(BalancerLoadCommonParameters1):
    with sdk2.parameters.RadioGroup('binary') as binary:
        binary.values['url'] = binary.Value('url', default=True)
        binary.values['sandbox'] = binary.Value('sandbox')
    with binary.value['url']:
        binary_url = sdk2.parameters.String('binary_url', required=True)
    with binary.value['sandbox']:
        binary_sandbox_resource = sdk2.parameters.Resource('binary_sandbox_resource', required=True)
