# -*- coding: utf-8 -*-

from sandbox.sdk2 import resource as s2r
from sandbox import sdk2
from sandbox.projects import resource_types as rt
from sandbox.projects.resource_types import releasers as rel


balancer_releasers = [
    'robot-srch-releaser',
    'robot-testenv',
    'alexeylaptev',
    'dmitryno',
    'mmike16',
    'nocomer',
    'smalukav',
    'romanovich',
    'disafonov',
    'ferenets',
    'soniachrn',
    'glebka97',
    'zaycevm',
]

balancer_config_releasers = balancer_releasers

_SERVAL_RELEASERS = ["dmitryno", "velavokr", "gluk47"] + rel.wizard_releasers

_SOLO_CREATOR_RELEASERS = [
    'robot-rainbow-dash',
    'alexeylaptev',
    'mmike16',
    'nocomer',
    'smalukav',
    'soniachrn',
    'glebka97',
    'zaycevm',
]


class ServalExecutable(sdk2.Resource):
    any_arch = False
    arcadia_build_path = "balancer/serval/serval"
    auto_backup = True
    executable = True
    releasable = True
    releasers = _SERVAL_RELEASERS


class ServalEvlogdump(sdk2.Resource):
    any_arch = False
    arcadia_build_path = "balancer/serval/tools/logdump/logdump"
    auto_backup = True
    executable = True
    releasable = True
    releasers = _SERVAL_RELEASERS


class ServalConfigs(sdk2.Resource):
    arcadia_build_path = "balancer/serval/bundle"
    build_artefact_path = "balancer/serval/bundle/balancer/serval/bundle"
    auto_backup = True
    releasable = True
    releasers = _SERVAL_RELEASERS


class BALANCER_GENCFG_CONFIGS_L7_TGZ(s2r.AbstractResource):
    """
        Архив со сгенеренными конфигами для l7 балансера
    """
    arcadia_build_path = "balancer/config/package/balancer.configs.tar.gz"
    auto_backup = True
    releasable = True
    executable = False
    releasers = balancer_config_releasers


class BALANCER_GENCFG_CONFIGS_L7_DIR(s2r.AbstractResource):
    """
        Директория со сгенеренными конфигами для l7 балансера
    """
    arcadia_build_path = "balancer/config/build"
    auto_backup = True
    releasable = True
    executable = False
    share = True  # please do not remove this, it is useful for testing
    releasers = balancer_config_releasers


class BALANCER_L7_YAV_DEPLOY_CONF(s2r.AbstractResource):
    """
        yav-deploy.conf для l7 балансеров
    """
    arcadia_build_path = "balancer/config/yav_deploy/yav-deploy.conf"
    auto_backup = True
    releasable = True
    executable = False
    share = True  # please do not remove this, it is useful for testing
    releasers = balancer_config_releasers


class BALANCER_EXECUTABLE(s2r.AbstractResource):
    """
        Исполняемый файл балансера
    """
    arcadia_build_path = 'balancer/daemons/balancer/balancer'
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = balancer_releasers


class BALANCER_EXECUTABLE_DEBUG(BALANCER_EXECUTABLE):
    """
        Исполняемый файл балансера собранный в дебажной сборке
    """


class BALANCER_EXECUTABLE_ASAN(BALANCER_EXECUTABLE):
    """
        Исполняемый файл балансера собранный под ASAN
    """


class BALANCER_EXECUTABLE_LSAN(BALANCER_EXECUTABLE):
    """
        Исполняемый файл балансера собранный под LSAN
    """


class BALANCER_EXECUTABLE_MSAN(BALANCER_EXECUTABLE):
    """
        Исполняемый файл балансера собранный под MSAN
    """


class LUA_TO_JSON(sdk2.Resource):
    """
        lua_to_json util for balancer config
    """
    any_arch = False
    auto_backup = True
    executable = True


class CORELIMIT_EXECUTABLE(sdk2.Resource):
    """
        corelimit utility for mass enabling coredumps
    """
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = balancer_releasers
    arcadia_build_path = 'balancer/production/x/corelimit/corelimit'


class TICKETS_DEPLOY_EXECUTABLE(sdk2.Resource):
    """
        tickets_deploy utility for tls tickets rotation
    """
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = balancer_releasers
    arcadia_build_path = 'balancer/production/tickets_deploy/tickets_deploy'


class BALANCER_IMPROXY_EXECUTABLE(s2r.AbstractResource):
    """
        Исполняемый файл тумбнейлерной прокси (балансера)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = rt.images_balancer_releasers + rel.video_robot_releasers
    release_subscribers = rt.images_thumb_subscribers + rt.video_robot_subscribers
    arcadia_build_path = 'balancer/daemons/balancer/balancer'


class L7_MONITORINGS_SOLO_CREATOR(sdk2.Resource):
    """
        Бинарный файл на основе Solo для создания алертов
    """
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = _SOLO_CREATOR_RELEASERS
    arcadia_build_path = 'balancer/production/l7_alerts/solomon/creator'


class BALANCER_PLAN(s2r.AbstractResource):
    """
        Бинарный файл плана долбилки с запросами к балансеру
    """
    auto_backup = True


class BALANCER_TEST_TOOLS(s2r.AbstractResource):
    """
        Инструменты, используемые в тестах балансера
    """
    any_arch = False
    executable = False
    releasable = False
    auto_backup = True


class BALANCER_CONFIG(s2r.AbstractResource):
    """
        Файл конфига для балансера
    """
    auto_backup = True
    releasable = True
    releasers = ['kimkim', 'kfour', 'kulikov'] + rt.images_releasers
    release_subscribers = ['kimkim']


class BALANCER_ADDRS_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_WEB_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_BARNAVIG_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_BLOG_SEARCH_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_CLICKS_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_CONQUISTA_CONFIG(BALANCER_CONFIG):
    pass


class MEDIA_OCSP_RESPONSE_FILES(s2r.AbstractResource):
    """
        Тарболл с ocsp ответами сертификатов медиа-поисков
    """
    releasable = True
    releasers = rel.multsearch
    release_subscribers = rel.video_robot_releasers


class IMAGES_OCSP_RESPONSE_FILES(s2r.AbstractResource):
    """
        Тарболл с ocsp ответами сертификатов проекта Яндекс.Картинки
    """
    releasable = True
    releasers = rel.multsearch
    release_subscribers = rel.media_sre


class BALANCER_MEDIA_LOGS(s2r.AbstractResource):
    """
        Директория с логами балансера медийных балансеров
    """
    share = False


class BALANCER_MEDIA_BDI_LOGS(s2r.AbstractResource):
    """
        Директория с логами балансера медийного BDI
    """
    share = False


class BALANCER_MEDIA_BDI_IMAGES_LOOP_CONFIG(s2r.AbstractResource):
    """
        Конфиг instancectl для BDI картинок
    """
    releasable = True
    releasers = rel.multsearch + rel.video
    release_subscribers = rel.media_sre


class BALANCER_MEDIA_BDI_IMAGES_SAS_CONFIG(BALANCER_CONFIG):
    """
        Конфиг BDI картинок в Сасово
    """
    releasable = True
    releasers = rel.multsearch + rel.video
    release_subscribers = rel.media_sre


class BALANCER_MEDIA_BDI_IMAGES_MAN_CONFIG(BALANCER_CONFIG):
    """
        Конфиг BDI картинок в Финке
    """
    releasable = True
    releasers = rel.multsearch + rel.video
    release_subscribers = rel.media_sre


class BALANCER_MEDIA_BDI_IMAGES_MSK_CONFIG(BALANCER_CONFIG):
    """
        Конфиг BDI картинок в Москве
    """
    releasable = True
    releasers = rel.multsearch + rel.video
    release_subscribers = rel.media_sre


class BALANCER_MEDIA_BDI_IMAGES_VLA_CONFIG(BALANCER_CONFIG):
    """
        Конфиг BDI картинок в Владимире
    """
    releasable = True
    releasers = rel.multsearch + rel.video
    release_subscribers = rel.media_sre


class BALANCER_MEDIA_BDI_VIDEO_LOOP_CONFIG(s2r.AbstractResource):
    """
        Конфиг instancectl для BDI картинок
    """
    releasable = True
    releasers = rel.multsearch + rel.video
    release_subscribers = rel.media_sre


class BALANCER_MEDIA_BDI_VIDEO_SAS_CONFIG(BALANCER_CONFIG):
    """
        Конфиг BDI видео в Сасово
    """
    releasable = True
    releasers = rel.multsearch + rel.video
    release_subscribers = rel.media_sre


class BALANCER_MEDIA_BDI_VIDEO_MAN_CONFIG(BALANCER_CONFIG):
    """
        Конфиг BDI видео в Финке
    """
    releasable = True
    releasers = rel.multsearch + rel.video
    release_subscribers = rel.media_sre


class BALANCER_MEDIA_BDI_VIDEO_VLA_CONFIG(BALANCER_CONFIG):
    """
        Конфиг BDI видео во Владимире
    """
    releasable = True
    releasers = rel.multsearch + rel.video
    release_subscribers = rel.media_sre


class BALANCER_RIM_SAS_CONFIG(BALANCER_CONFIG):
    """
        Конфиг балансера проекта RIM в Я.Картинках (Сасово)
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_RIM_MAN_CONFIG(BALANCER_CONFIG):
    """
        Конфиг балансера проекта RIM в Я.Картинках (Финка)
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_RIM_ACCEPTANCE_CONFIG(BALANCER_CONFIG):
    """
        Конфиг балансера проекта RIM в Я.Картинках (приёмка)
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_RIM_VLA_CONFIG(BALANCER_CONFIG):
    """
        Конфиг балансера проекта RIM в Я.Картинках (Владимир)
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_COMMERCIAL_VLA_CONFIG(BALANCER_CONFIG):
    """
        Конфиг балансера коммерческих данных в Я.Картинках (Владимир)
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_COMMERCIAL_SAS_CONFIG(BALANCER_CONFIG):
    """
        Конфиг балансера коммерческих данных в Я.Картинках (Сасово)
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_COMMERCIAL_MAN_CONFIG(BALANCER_CONFIG):
    """
        Конфиг балансера коммерческих данных в Я.Картинках (Финка)
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_COMMERCIAL_HAMSTER_SAS_CONFIG(BALANCER_CONFIG):
    """
        Конфиг балансера коммерческих данных для хамстера в Я.Картинках (Сасово)
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_COMMERCIAL_HAMSTER_MAN_CONFIG(BALANCER_CONFIG):
    """
        Конфиг балансера коммерческих данных для хамстера в Я.Картинках (Финка)
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_MEDIA_LOOP_CONFIG(s2r.AbstractResource):
    """
        Конфиг instancectl для медиа балансеров
    """
    releasable = True
    releasers = rel.media_sre
    release_subscribers = rel.media_sre


class BALANCER_MEDIA_LOOP_NG_CONFIG(s2r.AbstractResource):
    """
        Конфиг instancectl для медиа балансеров (с поддержкой layers)
    """
    releasable = True
    releasers = rel.media_sre + rt.images_releasers
    release_subscribers = rel.media_sre


class INT_IMAGES_LOOP_CONFIG(s2r.AbstractResource):
    """
        Конфиг instancectl для интов картинок
    """
    releasable = True
    releasers = rel.media_sre
    release_subscribers = rel.media_sre


class BASE_IMAGES_LOOP_CONFIG(s2r.AbstractResource):
    """
        Конфиг instancectl для базовых картинок
    """
    releasable = True
    releasers = rel.media_sre
    release_subscribers = rel.media_sre


class BALANCER_IMPROXY_IMAGES_MSK_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси картинок в Москве
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMAGES_MSK_INTERNAL_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси картинок в Москве для msk.im-tub.yandex.net
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMAGES_TUR_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси картинок в Турции
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMAGES_SAS_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси картинок в Сасово
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMAGES_SAS_INTERNAL_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси картинок в Москве для sas.im-tub.yandex.net
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMAGES_MAN_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси картинок в Финляндии
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMAGES_MAN_INTERNAL_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси картинок в Москве для man.im-tub.yandex.net
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMAGES_VLA_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси картинок в Владимире
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMAGES_VLA_INTERNAL_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси картинок в Владимире для vla.im-tub.yandex.net
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMAGES_PRIEMKA_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси картинок над приемкой
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_VIDEO_MSK_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси видео в Москве
    """
    releasers = rel.video_robot_releasers
    release_subscribers = rt.video_robot_subscribers


class BALANCER_IMPROXY_VIDEO_TUR_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси видео в Турции
    """
    releasers = rt.images_releasers + rel.video_robot_releasers


class BALANCER_IMPROXY_VIDEO_SAS_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси видео в Сасово
    """
    releasers = rel.video_robot_releasers
    release_subscribers = rt.video_robot_subscribers


class BALANCER_IMPROXY_VIDEO_MAN_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси видео в Финляндии
    """
    releasers = rel.video_robot_releasers
    release_subscribers = rt.video_robot_subscribers


class BALANCER_IMPROXY_VIDEO_VLA_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси видео во Владимире
    """
    releasers = rel.video_robot_releasers
    release_subscribers = rt.video_robot_subscribers


class BALANCER_IMPROXY_IMGCBIR_MSK_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси cbir в Москве
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMGCBIR_MAN_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси cbir в Финляндии
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMGCBIR_VLA_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси cbir в Владимире
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_IMGCBIR_SAS_CONFIG(BALANCER_CONFIG):
    """
        Конфиг тумбнейлерной прокси cbir в Сасово
    """
    releasers = rt.images_balancer_releasers
    release_subscribers = rt.images_thumb_subscribers


class BALANCER_IMPROXY_CACHER_CONFIG(BALANCER_CONFIG):
    """
        Конфиг отдельно стоящего кешера для балансера
        Устарел, вместо него используются отдельные типы ресурсов для разных сервисов
    """
    releasable = False
    releasers = rt.images_balancer_releasers


class BALANCER_IMPROXY_IMAGES_CACHER_CONFIG(BALANCER_IMPROXY_CACHER_CONFIG):
    """
        Конфиг отдельно стоящего картиночного кешера для балансера
    """
    releasable = True


class BALANCER_IMPROXY_VIDEO_CACHER_CONFIG(BALANCER_IMPROXY_CACHER_CONFIG):
    """
        Конфиг отдельно стоящего картиночного кешера для балансера
    """
    releasable = True


class BALANCER_LYRICSLOVER_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_MUSIC_MIC_SEARCH_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_NEWS_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_OPENSMETANKA_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_REQWIZARD_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_REQWIZARD_HAMSTER_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_RESINFOD_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_SMETANKA_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_SUGGEST_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_ANTIROBOT_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_MARKET_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_MORDAXML_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_RCA_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_XML_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_MOBILEREPORT_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_SYANDEXTEAM_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_SYANDEXTEAM_STABLE_RUCHKA_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_WEB_PRODUCTION_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_WEB_COM_PRODUCTION_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_WEB_PRODUCTION_COMTR_PROXY_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_WEB_PRODUCTION_COMTR_SEARCH_PROXY_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_WEB_MORDATEST_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_WEB_TEST_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_WEB_FAMILYSEARCH_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_BETAWEBMASTER_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_DOWNLOADLINKS_WEBMASTER_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_SITEBETA_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_MAPSUGGEST_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_BANFLT_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_NOTIFICATIONS_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_NOTIFICATIONS_INT_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_ASRSEARCH_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_RCSSEXT_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_RCSSINT_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_NOAPACHE_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_INDEXERPROXY_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_INDEXERPROXY_PRESTABLE_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_SEARCHPROXY_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_SEARCHPROXY_PRESTABLE_CONFIG(BALANCER_CONFIG):
    pass


class BALANCER_SAAS_INDEXER_PROXY_OUTGONE_BALANCER(BALANCER_CONFIG):
    pass


class BALANCER_GGS_CONFIG(BALANCER_CONFIG):
    pass


class L7_HEAVY_BALANCER_INSTANCECTL_CONF(s2r.Resource):
    """
        L7 Heavy instancectl.conf file
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = BALANCER_EXECUTABLE.releasers
    arcadia_build_path = 'balancer/production/instancectl_conf'
    arcadia_build_name = 'l7heavy_balancer_instancectl_conf'


class BALANCER_TESTS_DATA(s2r.AbstractResource):
    """
        Данные для тестов поискового балансера
    """
    uploadable = True
    auto_backup = True
    any_arch = True


class BALANCER_GENCFG_CONFIGS_TEST_TGZ(s2r.AbstractResource):
    """
        Архив со сгенеренными конфигами для l7 балансера
    """
    auto_backup = True
    releasable = True
    executable = False


class BALANCER_GENCFG_CONFIGS_TEST_DIR(s2r.AbstractResource):
    """
        Директория со сгенеренными конфигами для l7 балансера
    """
    auto_backup = True
    releasable = True
    executable = False
    share = False
