# -*- coding: utf-8 -*-
import os

from sandbox import sdk2
from sandbox.projects.common.arcadia import sdk as arc
from sandbox.projects.common.constants import YA_MAKE_FORCE_BUILD_SYSTEM
from sandbox.projects.common.nanny import nanny
from sandbox.projects.balancer import resources as rt


class ServalBuild(nanny.ReleaseToNannyTask2, sdk2.Task):
    """balancer/serval"""

    _RESOURCES = [
        rt.ServalExecutable,
        rt.ServalEvlogdump,
        rt.ServalConfigs,
    ]

    class Parameters(sdk2.Task.Parameters):
        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl("Arcadia URL", required=True)
        arcadia_patch = sdk2.parameters.String(
            "Patch (rbtorrent, raw paste link, or plain text; see https://nda.ya.ru/3QTTV4)",
            multiline=True,
            default=""
        )
        with sdk2.parameters.String("--build=", required=True) as build_type:
            build_type.values.release = build_type.Value("release", default=True)
            build_type.values.debug = "debug"
            build_type.values.profile = "profile"
            build_type.values.relwithdebinfo = "relwithdebinfo"
        with sdk2.parameters.String("--sanitize=") as sanitize:
            sanitize.values.none = build_type.Value("none", default=True)
            sanitize.values.address = "address"
            sanitize.values.leak = "leak"
            sanitize.values.memory = "memory"
            sanitize.values.thread = "thread"
            sanitize.values.undefined = "undefined"

    class Context(sdk2.Task.Context):
        resources = []

    def on_enqueue(self):
        self.Context.resources = [
            res(self,
                "-",
                os.path.join("build", getattr(res, "build_artefact_path", res.arcadia_build_path))).id
            for res in self._RESOURCES
        ]

    def on_execute(self):
        sdk2.path.Path("build").mkdir(mode=0o755, exist_ok=True)
        with arc.mount_arc_path(self.Parameters.checkout_arcadia_from_url) as arc_root:
            arc.do_build(
                build_system=YA_MAKE_FORCE_BUILD_SYSTEM,
                source_root=arc_root,
                targets=[res.arcadia_build_path for res in self._RESOURCES],
                clear_build=False,
                build_type=self.Parameters.build_type,
                sanitize=self.Parameters.sanitize if self.Parameters.sanitize != "none" else None,
                results_dir="build",
                patch=self.Parameters.arcadia_patch
            )
