import datetime

from sandbox.sandboxsdk.parameters import SandboxRadioParameter

import sandbox.projects.common.build.YaExec as ya_exec
import sandbox.projects.common.build.parameters as common_params
import sandbox.projects.common.utils as utils
import sandbox.sandboxsdk.parameters as parameters


class ReleaseTypeParam(SandboxRadioParameter):
    name = 'database_type'
    description = 'Type of the database'
    choices = [
        ('test', 'test'),
        ('beta', 'beta'),
        ('prod', 'prod')
    ]
    required = True
    default_value = 'test'


class BassDownloadKinopoiskSVODTask(ya_exec.YaExec):
    """ Run task to download kinopoisk SVOD content """

    type = 'BASS_DOWNLOAD_KINOPOISK_SVOD'

    input_parameters = [ReleaseTypeParam]

    def on_execute(self):
        token_placeholder = '$(vault:value:robot-bassist:robot-bassist_{}_token)'
        yt_token = token_placeholder.format('yt')
        ydb_token = token_placeholder.format('ydb')

        program = 'alice/bass/tools/video/kinopoisk_svod_downloader/kinopoisk_svod_downloader'

        kv = {
            'yt-table': '//home/kinopoisk/ext/production/yastation_onlines',
            'ydb-table': 'kinopoisk_svod_{}Z'.format(datetime.datetime.utcnow().strftime("%Y%m%dT%H%M%S")),
            'database': '/ru/alice/{}/bass'.format(utils.get_or_default(self.ctx, ReleaseTypeParam)),
            'endpoint': 'ydb-ru.yandex.net:2135'
        }

        env = ' '.join(['YT_TOKEN="{}"'.format(yt_token), 'YDB_TOKEN="{}"'.format(ydb_token)])
        args = ' '.join('--{}="{}"'.format(k, v) for k, v in kv.iteritems())

        self.ctx[parameters.SandboxArcadiaUrlParameter.name] = 'arcadia:/arc/trunk/arcadia'
        self.ctx[common_params.EnvironmentVarsParam.name] = env
        self.ctx[ya_exec.ProgramParam.name] = program
        self.ctx[ya_exec.ArgsParam.name] = args

        return ya_exec.YaExec.on_execute(self)
