import sandbox.projects.common.build.YaExecFuse as ya_exec_fuse
import sandbox.projects.common.build.parameters as common_params
import sandbox.sandboxsdk.parameters as parameters


class BassExtskillsGameOfCitiesCleanup(ya_exec_fuse.YaExecFuse):
    """ Run task to cleanup game's of cities sessions in ydb """

    type = 'BASS_EXTSKILLS_GAME_OF_CITIES_CLEANUP'

    input_parameters = []

    def on_execute(self):
        program = 'quality/functionality/alice_skills/game_of_cities/lib/ydb_cleanup/ydb_cleanup'

        token_placeholder = '$(vault:value:robot-bassist:robot-bassist_{}_token)'
        ydb_token = token_placeholder.format('ydb')
        env = 'YDB_TOKEN="{}"'.format(ydb_token)

        self.ctx[parameters.SandboxArcadiaUrlParameter.name] = 'arcadia:/arc/trunk/arcadia'
        self.ctx[common_params.EnvironmentVarsParam.name] = env
        self.ctx[ya_exec_fuse.ProgramParam.name] = program

        return ya_exec_fuse.YaExecFuse.on_execute(self)
