import sandbox.projects.common.build.YaExecFuse as ya_exec_fuse
import sandbox.projects.common.build.parameters as common_params
import sandbox.sandboxsdk.parameters as parameters


class BassExtskillsNewsFilterTask(ya_exec_fuse.YaExecFuse):
    """ Run task to filter news from turbopages """

    type = 'BASS_EXTSKILLS_NEWS_FILTER'

    input_parameters = []

    def on_execute(self):
        token_placeholder = '$(vault:value:robot-bassist:robot-bassist_{}_token)'
        yt_token = token_placeholder.format('yt')
        ydb_token = token_placeholder.format('ydb')

        program = 'quality/functionality/alice_skills/chat_bot_server/news/news_filter/news_filter'

        env = ' '.join(['YT_TOKEN="{}"'.format(yt_token), 'YDB_TOKEN="{}"'.format(ydb_token)])

        self.ctx[parameters.SandboxArcadiaUrlParameter.name] = 'arcadia:/arc/trunk/arcadia'
        self.ctx[common_params.EnvironmentVarsParam.name] = env
        self.ctx[ya_exec_fuse.ProgramParam.name] = program

        return ya_exec_fuse.YaExecFuse.on_execute(self)
