# -*- coding: utf-8 -*-

import os

from sandbox.projects.bass.common import resources as resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny


class BuildAliceChatBotPackage(YaMakeTask, nanny.ReleaseToNannyTask):

    type = 'BUILD_ALICE_CHAT_BOT_PACKAGE'

    TARGET_RESOURCE_TYPES = [
        resource_types.ALICE_CHAT_BOT_PACKAGE,
    ]

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildSystem,
        build_params.BuildType,
    ]

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMakeTask.on_release(self, additional_parameters)

    def get_targets(self):
        return [resource_type.arcadia_build_path
                for resource_type in self.TARGET_RESOURCE_TYPES]

    def get_resources(self):
        resources = {}
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_type.arcadia_build_path),
            }
            resources[resource_type.name] = resource

        return resources

    def get_arts(self):
        return [{'path': resource_type.arcadia_build_path} for resource_type in self.TARGET_RESOURCE_TYPES]


__Task__ = BuildAliceChatBotPackage
