# coding: utf-8
from sandbox import sdk2

from sandbox.projects.common.build import YaPackage
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk import parameters

import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.constants as consts


class ProtocolVideoScenarioPackageParameter(YaPackage.PackagesParameter):
    default_value = 'alice/bass/packages/bass_package.json'


class ProtocolVideoScenarioResourceTypeParameter(YaPackage.ResourceTypeParameter):
    default_value = 'PROTOCOL_VIDEO_SCENARIO_PACKAGE'


class BuildSystem(build_params.BuildSystem):
    default_value = consts.YA_MAKE_FORCE_BUILD_SYSTEM


class BuildType(build_params.BuildType):
    default_value = consts.RELEASE_BUILD_TYPE


class CopyTrunk(sdk2.parameters.Bool):
    name = consts.COPY_TRUNK
    description = 'Try to checkout branch by copying from trunk'
    default_value = False


class UseArcadiaApiFuse(build_params.UseArcadiaApiFuse):
    default_value = True


class AllowArcadiaApiFallback(build_params.AllowArcadiaApiFallback):
    default_value = True


class BuildProtocolVideoScenarioPackage(YaPackage.YaPackage, nanny.ReleaseToNannyTask):

    type = 'BUILD_PROTOCOL_VIDEO_SCENARIO_PACKAGE'

    input_parameters = [
        parameters.SandboxArcadiaUrlParameter,
        ProtocolVideoScenarioPackageParameter,
        ProtocolVideoScenarioResourceTypeParameter,
        build_params.ArcadiaPatch,
        YaPackage.RunTestsParameter,
        BuildSystem,
        BuildType,
        CopyTrunk,
        UseArcadiaApiFuse,
        AllowArcadiaApiFallback,
    ] + build_params.get_yt_store_params()

    execution_space = 100 * 1024

    def on_enqueue(self):

        input_parameters_names = set(parameter.name for parameter in self.input_parameters)
        for parameter in YaPackage.YaPackage.input_parameters:
            if parameter.name not in input_parameters_names:
                self.ctx[parameter.name] = parameter().default_value

        self.ctx.update({YaPackage.PackageTypeParameter.name: YaPackage.TARBALL})  # Create tarballs
        self.ctx.update({YaPackage.PublishPackageParameter.name: False})  # Don't publish anything
        self.ctx.update({YaPackage.RawPackageParameter.name: False})  # Compress package (.tar.gz)
        self.ctx["kill_timeout"] = 60 * 60 * 3  # 3 hours is enough

        YaPackage.YaPackage.on_enqueue(self)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaPackage.YaPackage.on_release(self, additional_parameters)


__Task__ = BuildProtocolVideoScenarioPackage
