# -*- coding: utf-8 -*-

from sandbox import sdk2

assistant_releasers = [
    'dpolukhin',
    'zador',
    'imakunin',
    'putrin',
    'jon2205',
    'petrk',
    'atsepeleva',
    'vi002',
    'robot-bassist',
    'akhruslan',
    'mihajlova',
    'a-sidorin',
    'ar7is7',
    'micyril',
    'mike88',
    'g-kostin',
    'ikorobtsev',
    'riariorovere',
    'alkapov',
]

protocol_video_releasers = [
    'mincer',
    'shaveinikovds',
    'justdev',
    'niketeen',
    'faust',
    'alex-garmash',
    'hellodima',
    'pazus',
    'akormushkin',
    'dandex',
    'kolchanovs',
    'robot-srch-releaser',
    'robot-testenv'
] + assistant_releasers


class ALICE_CITY_GAME_PACKAGE(sdk2.Resource):
    """
    Package for Game of Cities Alice's service
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = False
    releasers = assistant_releasers
    arcadia_build_path = 'quality/functionality/alice_skills/game_of_cities'


class ALICE_INTERACTIVE_FICTION_PACKAGE(sdk2.Resource):
    """
    Package for Interactive Fiction Alice's service
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = False
    releasers = assistant_releasers


class ALICE_LAOWAI_DATA(sdk2.Resource):
    """
    Data for Alice chineese quest game
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = False
    releasers = assistant_releasers


class ALICE_CHAT_BOT_PACKAGE(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = assistant_releasers
    release_subscribers = assistant_releasers
    arcadia_build_path = 'quality/functionality/alice_skills/chat_bot_server'


class ALICE_CHAT_BOT_ADMINKA(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = assistant_releasers
    release_subscribers = assistant_releasers
    arcadia_build_path = 'quality/functionality/alice_skills/chat_bot_adminka'


class ALICE_CHAT_BOT_VIEWER(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = assistant_releasers
    release_subscribers = assistant_releasers
    arcadia_build_path = 'quality/functionality/alice_skills/chat_bot_viewer'


class ALICE_BASS_YAV_WRAPPER(sdk2.Resource):
    """
    YAV wrapper to run binaries
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = False
    releasers = assistant_releasers
    arcadia_build_path = 'alice/bass/tools/yav_wrapper'


class ALICE_BASS_RELEASE_BOT(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = assistant_releasers
    release_subscribers = assistant_releasers
    arcadia_build_path = 'alice/bass/tools/bass_release_bot'


class PROTOCOL_VIDEO_SCENARIO_PACKAGE(sdk2.Resource):
    """
    Protocol video scenario package, bass inside
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = protocol_video_releasers
