# coding: utf-8

from sandbox.sandboxsdk import parameters

from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.build import YaPackage

import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.constants as consts


class BerthubPackageParameter(YaPackage.PackagesParameter):
    default_value = 'robot/bert/packages/berthub.json'


class BerthubResourceTypeParameter(YaPackage.ResourceTypeParameter):
    default_value = 'BERTHUB_PACKAGE'


class UseFuse(build_params.UseArcadiaApiFuse):
    default_value = True


class UseFuseFallback(build_params.AllowArcadiaApiFallback):
    default_value = True


class BuildSystem(build_params.BuildSystem):
    default_value = consts.SEMI_DISTBUILD_BUILD_SYSTEM


class BuildType(build_params.BuildType):
    default_value = consts.RELEASE_BUILD_TYPE


class RawPackage(YaPackage.RawPackageParameter):
    default_value = True


class BuildBerthubPackage(YaPackage.YaPackage, nanny.ReleaseToNannyTask):

    type = 'BUILD_BERTHUB_PACKAGE'

    input_parameters = [
        parameters.SandboxArcadiaUrlParameter,
        UseFuse,
        UseFuseFallback,
        BerthubPackageParameter,
        BerthubResourceTypeParameter,
        build_params.ArcadiaPatch,
        BuildSystem,
        BuildType,
        RawPackage
    ] + build_params.get_yt_store_params()

    execution_space = 150 * 1024

    def on_enqueue(self):

        input_parameters_names = set(parameter.name for parameter in self.input_parameters)
        for parameter in YaPackage.YaPackage.input_parameters:
            if parameter.name not in input_parameters_names:
                self.ctx[parameter.name] = parameter().default_value

        self.ctx.update({YaPackage.PackageTypeParameter.name: YaPackage.TARBALL})  # Create tarballs
        self.ctx.update({YaPackage.PublishPackageParameter.name: False})  # Don't publish anything

        YaPackage.YaPackage.on_enqueue(self)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaPackage.YaPackage.on_release(self, additional_parameters)


__Task__ = BuildBerthubPackage
