# coding: utf-8
#
import os

from sandbox.sdk2.resource import AbstractResource, Attributes


bigmod_releasers = [
    "noxandry",
    "vsuvorov",
    "abogutskiy",
    "rinatous",
    "dddlatyshev",
    "qugok",
    "sverlova-dv",
    "granilace",
    "crazyministr",
    "kpopov94",
    "artemkon",
    "nevstrui",
    "jpepper",
]


# base classes
class BIGMOD_SYMBOLS_ARCHIVE(AbstractResource):
    """
        Symbols from bigmod binaries
    """
    releasable = True
    executable = False
    any_arch = False
    releasers = bigmod_releasers


class BIGMOD_BINARY(AbstractResource):
    """
        Base class for binary files used in Bigmod Project.
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = bigmod_releasers
    is_static_resource = True

    @classmethod
    def get_resource_filename(cls):
        if cls.arcadia_build_path is None:
            return None
        return os.path.basename(cls.arcadia_build_path)

"""

  Bigmod Resources

"""


# Arcadia Files

class BIGMOD_SVN_CONFIGS(AbstractResource):
    """
        Class for Bigmod configs from svn
    """
    releasable = True
    executable = False
    releasers = bigmod_releasers

    @classmethod
    def get_resource_filename(cls):
        return "svn_configs.tar.gz"


class BIGMOD_FURY_CONFIGS(AbstractResource):
    """
        Class for Fury configs
    """
    releasable = True
    executable = False
    releasers = bigmod_releasers

    @classmethod
    def get_resource_filename(cls):
        return "fury_configs.tar.gz"


class BIGMOD_SVN_SCRIPTS(BIGMOD_SVN_CONFIGS):
    """
        Class for Bigmod scripts from svn
    """

    @classmethod
    def get_resource_filename(cls):
        return "scripts.tar.gz"


class BIGMOD_SVN_LOUPE_FRONTEND(BIGMOD_SVN_CONFIGS):
    """
        Class for Bigmod loupe frontend from svn
    """
    @classmethod
    def get_resource_filename(cls):
        return "loupe_frontend.tar.gz"


# Bigmod Main Daemons

class BIGMOD_GATEKEEPER(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/gatekeeper/server/gatekeeper'


class BIGMOD_MODHUB(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/modhub/server/modhub'


class BIGMOD_FUNNEL(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/funnel/server/funnel'


class BIGMOD_LOUPE(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/loupe/server/loupe'


class BIGMOD_DELAYED_AGENT(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/delayed_agent/server/delayed_agent'


class BIGMOD_DISPERSER(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/disperser/server/disperser'


class BIGMOD_TAXONOMY(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/taxonomy/server/taxonomy'


class BIGMOD_INDEXER(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/indexer/server/indexer'


class BIGMOD_COMPRESSOR(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/compressor/server/compressor'


# Bigmod fury binary here

class BIGMOD_FURY(BIGMOD_BINARY):
    arcadia_build_path = 'quality/antifraud/xurma/fury/server/afraudita-server'


# Bigmod Rays Binaries

class BIGMOD_TRANSCEIVER(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/transceiver/server/transceiver'


class BIGMOD_LBEXPORT(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/lbexport/server/lbexport'


class BIGMOD_HTTPEXCHANGE(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/httpexchange/server/httpexchange'


class BIGMOD_SERAPHIM(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/seraphim/server/seraphim'


class BIGMOD_DUMMY_FACTORY(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/dummy_factory/server/dummy_factory'


# Bigmod Models

class BIGMOD_MODELS_MULTIK(AbstractResource):
    """
        Class for Bigmod multik models
    """
    releasable = True
    executable = False
    releasers = bigmod_releasers

    @classmethod
    def get_resource_filename(cls):
        return "models_multik.tar.gz"


class BIGMOD_MODELS_COMMON(AbstractResource):
    """
        Class for Bigmod common models
    """
    releasable = True
    executable = False
    releasers = bigmod_releasers

    @classmethod
    def get_resource_filename(cls):
        return "models_common.tar.gz"


# Bigmod Offline

class BIGMOD_HARVESTER(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/harvester/server/harvester'


class BIGMOD_REDUCER(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/reducer/bin/reducer'


class BIGMOD_REVISER(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/reviser/server/reviser'


# Bigmod Tools

class BIGMOD_CREATE_INSTANCE_TOOL(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/tools/create_instance/create_instance'


class BIGMOD_STATIC_EVENTS_WRITER_TOOL(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/tools/static_events_writer/static_events_writer'


class BIGMOD_SATELLITE_TOOL(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/bigmod/tools/satellite/satellite'


class BIGMOD_REALTIME_MONITORING_TOOL(BIGMOD_BINARY):
    arcadia_build_path = 'modadvert/programs/rt_mod_mon/bin/rt_mod_mon'


# Bigmod Udfs

class BIGMOD_UDF_BASE(AbstractResource):
    arcadia_build_path = 'yql/udfs/modadvert/bigmod/libmodadvert_bigmod_udf.so'
    releasable = True
    executable = False
    group = 'Bigmod UDFs'
    releasers = bigmod_releasers

    production = Attributes.Bool("production")
    prestable = Attributes.Bool("prestable")


# Deprecated resource

class BIGMOD_LOUPE_FRONTEND(BIGMOD_SVN_CONFIGS):
    pass


class BIGMOD_UDF_READ_STATE(AbstractResource):
    pass
