# -*- coding: utf-8 -*-

from sandbox.sdk2 import Task


def get_module_from_path(path):
    parts = path.rsplit('/', 1)
    if len(parts) != 2:
        raise Exception('Binary path is invalid, '
                        'it must contain the path to the bin in the module, for example /root/module/base_bin')
    return parts[0]


def get_default_fuse_task_parameters():
    return {
        'build_system': 'ya',
        'create_sub_task': True,
        'use_arc_instead_of_aapi': True,
    }


def enqueue_fuse_task(parent, parameters):
    FuseTask = Task['YA_EXEC_FUSE']

    # because PY23_LIBRARY
    all_parameters = get_default_fuse_task_parameters()
    all_parameters.update(parameters)
    return FuseTask(parent, **all_parameters).save().enqueue()
