# import other resources
from sandbox.projects.billing.resources.faas import FaasResource  # noqa
from sandbox import sdk2

ROBOT_CI = 'robot-nb-ci'
ROBOT_SANDBOX = 'robot-nb-sandbox'


class BillingBaseResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = [ROBOT_CI]


# Tariffer resources

class HotBillingManificenta(BillingBaseResource):  # HOT_BILLING_MANIFICENTA
    releasers = [ROBOT_SANDBOX]


class HotBillingMediator(BillingBaseResource):  # HOT_BILLING_MEDIATOR
    pass


class HotBillingProcessor(BillingBaseResource):  # HOT_BILLING_PROCESSOR
    pass


class HotBillingProcessorConfig(BillingBaseResource):  # HOT_BILLING_PROCESSOR_CONFIG
    pass


class HotBillingCalculator(BillingBaseResource):  # HOT_BILLING_CALCULATOR
    pass


class HotBillingDiod(BillingBaseResource):  # HOT_BILLING_DIOD
    pass


# Configdepot resources

class HotBillingConfigdepot(BillingBaseResource):  # HOT_BILLING_CONFIGDEPOT
    pass


class HotBillingConfigdepotConfig(BillingBaseResource):  # HOT_BILLING_CONFIGDEPOT_CONFIG
    pass


# Accounts resources

class HotBillingAccounts(BillingBaseResource):  # HOT_BILLING_ACCOUNTS
    pass


# Payout resources

class HotBillingPayoutApi(BillingBaseResource):  # HOT_BILLING_PAYOUT_API
    pass


class HotBillingPayoutOebsGate(BillingBaseResource):  # HOT_BILLING_PAYOUT_OEBS_GATE
    pass


class HotBillingPayoutReqGate(BillingBaseResource):  # HOT_BILLING_PAYOUT_REQ_GATE
    pass


class HotBillingPayoutExporter(BillingBaseResource):  # HOT_BILLING_PAYOUT_EXPORTER
    pass


class HotBillingPayoutTasks(BillingBaseResource):  # HOT_BILLING_PAYOUT_TASKS
    pass


class HotBillingPayoutMigrations(BillingBaseResource):  # HOT_BILLING_PAYOUT_MIGRATIONS
    pass


# Accrualer resources

class HotBillingAccrualerProcessor(BillingBaseResource):  # HOT_BILLING_ACCRUALER_PROCESSOR
    pass


class HotBillingAccrualerMigrations(BillingBaseResource):  # HOT_BILLING_ACCRUALER_MIGRATIONS
    pass


# Scheduler resources

class HotBillingScheduler(BillingBaseResource):  # HOT_BILLING_SCHEDULER
    pass


# Configshop resources

class BillingConfigshop(BillingBaseResource):  # BILLING_CONFIGSHOP
    pass


# Oplata resources

class BillingOplata(BillingBaseResource):  # BILLING_OPLATA
    pass


# Billing

class BillingCommonConfig(BillingBaseResource):  # BILLING_COMMON_CONFIG
    pass
