from sandbox import sdk2

BILLING_CI = "BILLING-CI"


class FaasResource(sdk2.Resource):
    """ Faas resource for saving binaries """
    releasable = True
    share = True  # create rbtorrent resource

    revision = sdk2.Attributes.Integer("Revision", required=True)
    function_peerdir = sdk2.Attributes.String("Function peerdir", required=True)
    function = sdk2.Attributes.String("Function", required=True)
    namespaces = sdk2.Attributes.String("Faas service namespaces", required=True)
    endpoint = sdk2.Attributes.String("Endpoint title", required=True)
    # current_enviroment shows what enviroment resource was created for,
    #  so that next DeployFaas job uses only resources prepared for it.
    # This field resolves problem https://st.yandex-team.ru/BILLING-927 but,
    #  it allow only for sequential resource delivery [dev -> test -> prod].
    # Reusability of resources and problem of copying all resources from previous
    #  jobs does not allow for correct delivery of REUSABLE and only NEEDED resources.
    current_enviroment = sdk2.Attributes.String("Current environment")
    patch = sdk2.Attributes.Integer("Patch")
