from os import path

from jinja2 import Environment, BaseLoader
from library.python import resource

_arcadia_file_template = "https://a.yandex-team.ru/arc_vcs/{path}?rev=r{revision}"
_template_file = "templates/report.html"


report_is_not_ready = '<h1 style="color: red;">Report is not ready</h1>'


def load_template(tenants):
    env = Environment(loader=BaseLoader)
    template_path = path.join("resfs/file", _template_file)
    content = resource.find(template_path)
    template = env.from_string(content.decode("utf-8"))

    report_data = dict()
    table_config = dict()

    for tenant_name, tenant_data in tenants.items():
        report_data[tenant_name] = dict()
        table_config[tenant_name] = {"total_rows": 0, "instances": dict(), "namespaces": tenant_data["namespaces"]}

        for instance_name, instance_data in tenant_data["instances"].items():
            instance_endpoints = instance_data["endpoints"]
            instance_config = {
                "endpoints": list(),
                "instance_settings": {
                    "peerdirs": list(),
                    "revision": 0,
                },
            }
            table_config[tenant_name]["instances"][instance_name] = {"rows": len(instance_endpoints)}
            table_config[tenant_name]["total_rows"] += len(instance_endpoints)
            peerdirs = set()
            for endpoint in instance_endpoints:
                # TODO(@bremk): support other languages.
                function_path = endpoint["function"].rsplit(".", 1)[0].replace(".", "/") + ".py"
                arcadia_function = _arcadia_file_template.format(path=function_path, revision=endpoint["revision"])

                if instance_config["instance_settings"]["revision"] == 0:
                    instance_config["instance_settings"]["revision"] = endpoint["revision"]

                instance_config["endpoints"].append(
                    {
                        "url": arcadia_function,
                        "function": endpoint["function"],
                        "name": endpoint["endpoint"],
                    }
                )
                peerdirs.add(endpoint["peerdir"])

            for peerdir in peerdirs:
                instance_config["instance_settings"]["peerdirs"].append(
                    {
                        "url": _arcadia_file_template.format(
                            path=peerdir,
                            revision=instance_config["instance_settings"]["revision"],
                        ),
                        "text": peerdir,
                    }
                )
            report_data[tenant_name][instance_name] = instance_config
    return template.render({"report_data": report_data, "table_config": table_config})
