from marshmallow import Schema, fields


class DcSchema(Schema):
    name = fields.String(required=True)
    amount = fields.Integer(required=True, default=0)


class InstanceSchema(Schema):
    name = fields.String(required=True)
    active = fields.Bool(default=True, missing=True)
    dcs = fields.Nested(DcSchema, many=True, default=list, missing=list)


class TenantSchema(Schema):
    name = fields.String(required=True)
    instances = fields.Nested(InstanceSchema, many=True, default=list, missing=list)


class ConfigSchema(Schema):
    tenants = fields.Nested(TenantSchema, many=True)


class NamespaceFaasConfigSchema(Schema):
    tenants = fields.List(fields.String(default=""), missing=list, default=list)


class FaasSchema(Schema):
    pr_id = fields.Integer(default=0, missing=0)
    function = fields.String(required=True)
    peerdir = fields.String(required=True)
    revision = fields.Integer(required=True)
    instance = fields.String(default="default", missing="default")
    settings = fields.Dict(required=False, default=dict, missing=dict)


class BuildTaskConfigSchema(Schema):
    # Settings are not included in build task to avoid large requests.
    # See https://st.yandex-team.ru/BILLING-1285#62b06fa83d8ead2127f66c4c

    function = fields.String(required=True)
    name = fields.String(required=True)


dc_schema = DcSchema()
instance_schema = InstanceSchema()
tenant_schema = TenantSchema()
config_schema = ConfigSchema()
faas_schema = FaasSchema()
namespace_faas_schema = NamespaceFaasConfigSchema()
build_task_config_schema = BuildTaskConfigSchema()
