from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.sandboxsdk import errors


class BillingNirvanaUploadOperations(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        owner = "g:billing"
        description = "Run Billing Nirvana upload operations from Arcadia"
        config_path = sdk2.parameters.String("Generated config path", default="billing/log_tariffication/nirvana/operations/generated")
        revision = sdk2.parameters.Integer("Revision")
        import_timeout = sdk2.parameters.Integer("Import Operation Timeout in sec", default=60)
        program = sdk2.parameters.String("Path to import script", default="billing/infra/deploy/nirvana/operations/operations")

        with sdk2.parameters.RadioGroup("Nirvana Environment") as EnvironmentType:
            EnvironmentType.values["prod"] = EnvironmentType.Value("prod", default=True)
            EnvironmentType.values["test"] = EnvironmentType.Value("test")

        with sdk2.parameters.RadioGroup("Log level") as LogLevelType:
            LogLevelType.values["info"] = LogLevelType.Value("info", default=True)
            LogLevelType.values["debug"] = LogLevelType.Value("debug")
            LogLevelType.values["warning"] = LogLevelType.Value("warning")
            LogLevelType.values["error"] = LogLevelType.Value("error")
            LogLevelType.values["critical"] = LogLevelType.Value("critical")

    def on_execute(self):
        secret = sdk2.yav.Secret("sec-01dg4tavj7jp3fkwhyh9pnq8tv", "ver-01dgd2fhf4v3bnpcv11gyzqwq5")
        nirvana_token = secret.data()["nirvana_token"]
        with self.memoize_stage.create_children:
            task_class = sdk2.Task["YA_EXEC_FUSE"]
            sub_task = task_class(
                self,
                description="Child of task {}".format(self.id),
                owner=self.owner,
                create_sub_task=False,
                checkout_arcadia_from_url="arcadia:/arc/trunk/arcadia",
                program=self.Parameters.program,
                program_args="-env {0} -token {1} -cpath {2} -r {3} -it {4} -ll {5}".format(
                             self.Parameters.EnvironmentType,
                             nirvana_token,
                             self.Parameters.config_path,
                             self.Parameters.revision,
                             self.Parameters.import_timeout,
                             self.Parameters.LogLevelType
                )
            )
            sub_task = sub_task.save().enqueue()
            raise sdk2.WaitTask(
                sub_task,
                (ctt.Status.Group.FINISH, ctt.Status.Group.BREAK)
            )

        child_tasks = self.find()
        for task in child_tasks:
            if task.status not in ctt.Status.Group.SUCCEED:
                raise errors.SandboxTaskFailureError("Child task has failed.")
