from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.sandboxsdk import errors


class BillingNirvanaUploadWorkflow(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        owner = "g:billing"
        description = "Run Billing Nirvana upload workflow from Arcadia"
        config_file_path = sdk2.parameters.String("Config file path", default="billing/infra/deploy/nirvana/workflow/example_config/graph.json")
        template_params_file = sdk2.parameters.String("Template parameters file", default="billing/infra/deploy/nirvana/workflow/example_config/template_params.json")
        program = sdk2.parameters.String("Path to import script", default="billing/infra/deploy/nirvana/workflow/workflow")

        with sdk2.parameters.RadioGroup("Nirvana Environment") as EnvironmentType:
            EnvironmentType.values["prod"] = EnvironmentType.Value("prod", default=True)
            EnvironmentType.values["test"] = EnvironmentType.Value("test")

    def on_execute(self):
        secret = sdk2.yav.Secret("sec-01dg4tavj7jp3fkwhyh9pnq8tv", "ver-01dgd2fhf4v3bnpcv11gyzqwq5")
        nirvana_token = secret.data()["default_value"]
        with self.memoize_stage.create_children:
            task_class = sdk2.Task["YA_EXEC_FUSE"]
            sub_task = task_class(
                self,
                description="Child of task {}".format(self.id),
                owner=self.owner,
                create_sub_task=False,
                checkout_arcadia_from_url="arcadia:/arc/trunk/arcadia",
                program=self.Parameters.program,
                program_args="-env {0} -token {1} -cfile {2} -tfile {3}".format(
                             self.Parameters.EnvironmentType,
                             nirvana_token,
                             self.Parameters.config_file_path,
                             self.Parameters.template_params_file
                )
            )
            sub_task = sub_task.save().enqueue()
            raise sdk2.WaitTask(
                sub_task,
                (ctt.Status.Group.FINISH, ctt.Status.Group.BREAK)
            )

        child_tasks = self.find()
        for task in child_tasks:
            if task.status not in ctt.Status.Group.SUCCEED:
                raise errors.SandboxTaskFailureError("Child task has failed.")
