from sandbox import sdk2


class GitParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Git parameters') as git_block:
        ref_id = sdk2.parameters.String('ref_id', description='Git ref id', default='master', required=True)
        ref_sha = sdk2.parameters.String('ref_sha', description='Git ref SHA', default='', required=False)
        repo_url = sdk2.parameters.String('repo_url', description='Git repo URL', default='', required=True)
        vault_secret_owner = sdk2.parameters.String('vault_secret_owner',
                                                    description='Vault Secret owner',
                                                    default='',
                                                    required=False
                                                    )
        vault_secret_name = sdk2.parameters.String('vault_secret_name',
                                                   description='Vault Secret Name',
                                                   default='bitbucket_token',
                                                   required=False
                                                   )
        vault_secret_user = sdk2.parameters.String('vault_secret_user',
                                                   description='Vault Secret User Name',
                                                   default='x-oauth-token',
                                                   required=False
                                                   )
