from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.projects.resource_types.releasers import blender_releasers, experiment_releasers


class BlenderDssmModel(sdk2.resource.AbstractResource):
    intent = sdk2.Attributes.String('intent')
    dates = sdk2.Attributes.String('dates')


class BlenderModel(sdk2.resource.AbstractResource):
    restart_policy = ctr.RestartPolicy.RESET


class BlenderNirvanaOutput(sdk2.resource.AbstractResource):
    restart_policy = ctr.RestartPolicy.RESET


class PrismQueryClassifier(sdk2.Resource):
    pass


class PrismVideoQueryClassifier(sdk2.Resource):
    pass


class PrismQueryClassifierBegemot(sdk2.Resource):
    pass


class PrismVideoQueryClassifierBegemot(sdk2.Resource):
    pass


class BlenderProcessesParameterGeneratorExecutable(sdk2.Resource):
    """
    Blender nirvana_parameters_generator executable for blender processes.
    """
    arcadia_build_path = 'yweb/blender/processes/nirvana_parameters_generator/nirvana_parameters_generator'
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = blender_releasers


class BlenderRandomPoolExecutable(sdk2.Resource):
    """
    Blender random_pool executable.
    """
    arcadia_build_path = 'yweb/blender/random_pool/random_pool'
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = blender_releasers + experiment_releasers  # used in abt release machine


class BlenderSurplusSqueezeExecutable(sdk2.Resource):
    """
    Blender surplus_squeeze executable.
    """
    arcadia_build_path = 'yweb/blender/surplus_squeeze/surplus_squeeze'
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = blender_releasers + experiment_releasers  # used in abt release machine


class BlenderWizardsClicksExecutable(sdk2.Resource):
    """
    Blender wizards_clicks executable.
    """
    arcadia_build_path = 'quality/blender/wizards_clicks/wizards_clicks'
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = blender_releasers + experiment_releasers  # used in abt release machine
