from sandbox.common.types.task import Status
from sandbox.common.errors import TaskFailure


def ensure_subtask_is_successful(task, parent_task):
    statuses = [t.status for t in parent_task.find(id=task)]
    if not all(s == Status.SUCCESS for s in statuses):
        raise TaskFailure('Child task {} is failed, status: {}'.format(task, ', '.join(statuses)))
