# coding: utf-8
from sandbox import sdk2

import sandbox.projects.resource_types.releasers as releasers

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource


class BNPL_BACKEND(AbstractResource):
    """
        BNPL related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    ttl = 7
    releasers = releasers.bnpl_releasers
    arcadia_build_path = 'fintech/bnpl/backend'


class FintechBnplResourceBase(sdk2.Resource):
    releasable = True
    releasers = releasers.bnpl_releasers


class FINTECH_BNPL_RESOURCES(FintechBnplResourceBase):
    pass
