import json
import os

from sandbox import sdk2
from sandbox.sdk2 import ssh
from sandbox.sdk2.vcs import svn
from sandbox.common import rest
from sandbox.common.proxy import OAuth


class BmDumpSchedulers(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        ssh_key = sdk2.parameters.String('SSH key vault (in the form of owner:name).')
        sb_token = sdk2.parameters.String('SB token vault (in the form of owner:name).')
        query = sdk2.parameters.String('Query like: {"limit": 100, "owner": "BROADMATCH"}')
        path = sdk2.parameters.String('Path like: rt-research/broadmatching/mr/monitoring/sb_schedulers/schedulers.json')
        message = sdk2.parameters.String('Message like: IRT-1703: Update schedulers.json')

    @staticmethod
    def get_scheduler_brief_definition(item, client):
        resp = client.scheduler[item['id']].read()
        return {
            'id': item['id'],
            'status': 'STOPPED' if item['status'] == 'STOPPED' else 'WAITING',  # To prevent unnecessary updates
            'schedule': item['schedule'],
            'task': {
                'type': item.get('task', {}).get('type'),
                'custom_fields': map(
                    lambda x: {k: v for k, v in x.items() if k in {'name', 'value'}},
                    resp.get("task", {}).get("custom_fields", [])
                )
            }
        }

    def on_execute(self):
        ssh_key_owner, ssh_key_name = self.Parameters.ssh_key.split(':')
        sb_token_owner, sb_token_name = self.Parameters.sb_token.split(':')

        sb_token = sdk2.Vault.data(sb_token_owner, sb_token_name)
        client = rest.Client(auth=OAuth(sb_token))
        new_schedulers = []
        for item in client.scheduler.read(json.loads(self.Parameters.query))['items']:
            item_def = self.get_scheduler_brief_definition(item, client)
            if item_def:
                new_schedulers.append(item_def)
        new_schedulers.sort(key=lambda x: x.get('id'))
        new = json.dumps(new_schedulers, sort_keys=True, indent=4, separators=(',', ': '))

        url = "arcadia:/arc/trunk/arcadia"
        arcadia_dir = 'arcadia'
        with ssh.Key(self, key_owner=ssh_key_owner, key_name=ssh_key_name):
            os.mkdir(arcadia_dir)
            file_path = os.path.join(arcadia_dir, self.Parameters.path)
            svn.Arcadia.checkout(url, path=arcadia_dir, depth='empty')
            svn.Arcadia.update(file_path, depth='empty', parents=True)
            with open(file_path, 'w') as f:
                print >> f, new
            commit_message = self.Parameters.message
            svn.Arcadia.commit(arcadia_dir, commit_message, user=ssh_key_owner)
