from sandbox import sdk2
from sandbox.sdk2.parameters import LastReleasedResource, String, Integer
import sandbox.common.types.resource as ctr

from sandbox.projects.broadmatching import BroadmatchingBinary, BroadmatchingTask


class BroadmatchingBannerPhraseStatBinary(BroadmatchingBinary):
    pass


class BroadmatchingBannerPhraseStat(BroadmatchingTask):
    class Parameters(sdk2.Parameters):
        binary_id = LastReleasedResource(
            "broadmatching: 'banner_phrase_stat' binary",
            resource_type=BroadmatchingBannerPhraseStatBinary,
            state=(ctr.State.READY,),
            required=True
        )

        src_bs_chevent_log_dir = String('src YT directory with bs-chevent-logs', required=True)
        dst_banner_phrase_stat_dir = String('dst YT directory with BannerPhraseStat logs', required=True)
        src_n_tables = Integer('Number of last tables to process in src (if not set or 0, all tables are processed)')
        dst_n_tables = Integer('Number of tables to keep in dst (if not set or 0, all tables are kept)')

    def on_execute(self):
        args = [
            ('--src-bs-chevent-log-dir', self.Parameters.src_bs_chevent_log_dir),
            ('--dst-banner-phrase-stat-dir', self.Parameters.dst_banner_phrase_stat_dir),
        ]

        if self.Parameters.src_n_tables:
            args.append(('--src-n-tables', self.Parameters.src_n_tables))

        if self.Parameters.dst_n_tables:
            args.append(('--dst-n-tables', self.Parameters.dst_n_tables))

        self.run_binary_with_args(args)
