# -*- coding: utf-8 -*-

import os

from sandbox import sdk2

from sandbox.projects.broadmatching import YTVirtualEnvironment


class BmCollectCampaignBmStat(sdk2.Task):
    """Collect table CampaignIsBMStat"""

    class Parameters(sdk2.Task.Parameters):
        src_cluster = sdk2.parameters.String('Source cluster', required=True, default='seneca-myt')
        src_stat_table = sdk2.parameters.String('Source stat table', required=True, default='//yabs/OrderTimeExpBMStat')
        dst_cluster = sdk2.parameters.String('Destination cluster', required=True, default='hahn')
        dst_stat_table = sdk2.parameters.String('Destination stat table', required=True)
        yt_pool = sdk2.parameters.String('YT pool', required=True, default='broadmatching')

    def on_execute(self):
        with YTVirtualEnvironment(env_vars={
            'YT_TOKEN': sdk2.Vault.data(self.author, "YT_TOKEN"),
            'YQL_TOKEN': sdk2.Vault.data(self.author, "YQL_TOKEN"),
        }) as env:
            par = self.Parameters
            env.run_python_script([
                os.path.join(os.path.dirname(__file__), 'collect-campaign-stat.py'),
                '--src-cluster', par.src_cluster,
                '--src-stat-table', par.src_stat_table,
                '--dst-cluster', par.dst_cluster,
                '--dst-stat-table', par.dst_stat_table,
                '--yt-pool', par.yt_pool,
            ], log_prefix='collect_campaign_stat')
