# -*- coding: utf-8 -*-

import json
import os
import sys

import sandbox.sandboxsdk.svn as sdk_svn
from sandbox import sdk2

from sandbox.projects.broadmatching import YTVirtualEnvironment


class BmConvertExternalCandidates(sdk2.Task):
    """Convert tables with broadmatch external candidates to YT format"""

    class Parameters(sdk2.Task.Parameters):
        dst_cdict_table = sdk2.parameters.String('Destination table in cdict format', required=True,
                                                 default='//home/broadmatching/work/cdict/ExternalCandidates')

    def on_execute(self):
        with YTVirtualEnvironment(env_vars={'YT_TOKEN': sdk2.Vault.data(self.author, "YT_TOKEN")}) as env:
            arc_path_scripts = sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/rt-research/broadmatching")
            sys.path.append(os.path.join(arc_path_scripts, 'scripts', 'pylib'))
            from bm.utils import get_common_option

            external_config = get_common_option('external_candidates')
            par = self.Parameters
            env.run_python_script([
                os.path.join(os.path.dirname(__file__), 'runner.py'),
                '--external-config-json', json.dumps(external_config),
                '--dst-cdict-table', par.dst_cdict_table,
            ], log_prefix='convert_external_candidates')
