# -*- coding: utf-8 -*-

import os

from sandbox.projects.broadmatching import YTVirtualEnvironment
from sandbox import sdk2


class BmTransferDirectLimits(sdk2.Task):
    """ Transfer table with broadmatch limits from Direct to BS """

    class Parameters(sdk2.Task.Parameters):
        source_cluster = sdk2.parameters.String('Source cluster', required=True, default='hahn')
        destination_cluster = sdk2.parameters.String('Destination cluster', required=True, default='alyx')
        source_table = sdk2.parameters.String('Source table', required=True, default='//home/broadmatching/work/BroadmatchLimitsDirect')
        destination = sdk2.parameters.String('Destination link', required=True, default='//home/serkh/broadmatch-limitation/direct-limits/BroadmatchLimitsDirect')
        yql_transform_query = sdk2.parameters.String('YQL transform query', required=True, default='select OrderID, bm_share as CostLimit')
        cleanup = sdk2.parameters.Bool('Cleanup storage', default=True)

    def on_execute(self):
        yt_token = sdk2.Vault.data(self.author, "YT_TOKEN")
        yql_token = sdk2.Vault.data(self.author, "YQL_TOKEN")
        with YTVirtualEnvironment(env_vars={'YT_TOKEN': yt_token, 'YQL_TOKEN': yql_token}) as env:
            par = self.Parameters
            cmd = [
                os.path.join(os.path.dirname(__file__), 'transfer-direct-table.py'),
                '--source-cluster', par.source_cluster,
                '--destination-cluster', par.destination_cluster,
                '--source-table', par.source_table,
                '--destination', par.destination,
                '--yql-transform-query', par.yql_transform_query,
            ]
            if par.cleanup:
                cmd.append('--cleanup')
            env.run_python_script(cmd, log_prefix='yt_runner')
