import contextlib
import logging
import time
import urllib2

import sandbox.common.types.client as ctc
import sandbox.common.types.misc as ctm

# from sandbox.projects.sandbox import LXC_CONTAINER  # see below

from sandbox import sdk2


RESOLV_CONF_PATH = '/etc/resolv.conf'


class PingBrowserInfra(sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.BROWSER
        dns = ctm.DnsType.LOCAL
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        _container = sdk2.parameters.Container(
            "Container", default=None, required=False,
            # type=LXC_CONTAINER  # FIXME: invalid argument (SANDBOX-6404)
        )

    @staticmethod
    def read_resolv_conf():
        with open(RESOLV_CONF_PATH, 'rb') as resolv_conf:
            return resolv_conf.read()

    def on_execute(self):
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger(__file__)) as logger:
            logger = logger.logger
            logger.info('%s:\n%s', RESOLV_CONF_PATH, self.read_resolv_conf())
            for i in xrange(1000):
                with contextlib.closing(urllib2.urlopen('https://infra.browser.yandex-team.ru/ping')) as ping:
                    logger.info('%d: %s', i, ping.read())
                time.sleep(0.1)
