import sandbox.common.errors as ce
import sandbox.common.types.client as ctc

from sandbox.projects.browser.common.git import ConfigureGitEnvironment
from sandbox.projects.browser.common.RunYinScript import RunYinScript

from sandbox import sdk2


class RunYinTests(RunYinScript):
    class Requirements(RunYinScript.Requirements):
        client_tags = ctc.Tag.BROWSER
        cores = 1
        ram = 4 * 1024
        environments = RunYinScript.Requirements.environments.default + (
            ConfigureGitEnvironment('teamcity@yandex-team.ru', 'Teamcity'),
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(RunYinScript.Parameters):
        kill_timeout = 60 * 60

        with sdk2.parameters.Group('Task settings') as task_settings:
            additional_tags = sdk2.parameters.CustomClientTags(
                'Additional client tags (will be intersected with default)')

        _container = sdk2.parameters.Container('LXC container', default=None, required=False)

    PROVIDE_DEPOT_TOOLS = True

    def on_enqueue(self):
        super(RunYinTests, self).on_enqueue()
        if self.Parameters.additional_tags:
            self.Requirements.client_tags &= self.Parameters.additional_tags

    def requirements_files(self):
        files = super(RunYinTests, self).requirements_files()
        files += [
            self.yin_path('yin', 'perf', 'requirements', 'ml.txt'),
            self.yin_path('yin', 'perf', 'requirements', 'stats.txt'),
        ]
        return files

    def script_cmd(self, python_executable):
        return [
            str(python_executable), '-m', 'pytest',
            '--teamcity',
        ]

    def handle_script_error(self, error):
        super(RunYinTests, self).handle_script_error(error)
        raise ce.TaskFailure('Tests failed')
