# -*- encoding: utf-8 -*-
from collections import namedtuple

from sandbox.projects.browser.ab_experiments.ab_service import Queue
from sandbox.projects.browser.ab_experiments.BrowserExperimentsAbChecklist.checklists import util
from sandbox.projects.browser.ab_experiments.channels import Channel


ChecklistItem = namedtuple('ChecklistItem', ('text', 'checked'))


class _AnyParam(object):
    def __hash__(self):
        return super(_AnyParam, self).__hash__()

    def __eq__(self, other):
        return True

_ANY = _AnyParam()

_DEBRO_ABT_DEV = (
    (u'[Менеджер] Фича согласована с руководителем платформы к включению в бротиме (shibanov@) '
     u'(в тикете на эксперимент, технические эксперименты можно в уведомительном порядке)'),
    u'[Отв. тестировщик] Фича протестированна в версии, в которой будет включаться',
)

_DEBRO_ABT_BETA = (
    u'[Менеджер] Фича включена в бротиме',
    u'[Отв. тестировщик] Фича протестированна в версии, в которой будет включаться',
    u'[Отв. тестировщик] Изменения в конфиге соответствуют описанию в тикете',
    u'[Отв. тестировщик] Фича имеет достаточное качества для выхода в эксперимент',
)

_DEBRO_ABT_PRODUCTION = (
    u'[Отв. тестировщик] Изменения в конфиге соответствуют описанию в тикете',
    u'[Отв. тестировщик] Фича протестирована в версии, в которой планируется запуск эксперимента',
    u'[Отв. тестировщик] Добавлены скриншоты/видео работы фичи (было/стало)',
    (u'[Отв. тестировщик] Фича запущена в бете в той же конфигурации '
     u'(в случае отличия в тикете нужен аппрув руководителя разработки (@dmgor) и руководителя платформы (@shibanov))'
     ),
    u'[Отв. тестировщик] Фича имеет достаточное качества для выхода в эксперимент (отсутствуют криты)',
    u'[Отв. тестировщик] Написан и отправлен отчет о тестировании фичи',
    u'[Отв. тестировщик] Автоматизированы кейсы с приоритетом Blocker',
    u'[Менеджер] Узнать у саппорта фидбек по фиче с беты',
    u'[Менеджер] Настроены велкамы фичи (или они не нужны)',
    u'[Менеджер] Размер аудитории эксперимента согласован с ответственным аналитиком (если превышает 5%)',
    u'[Менеджер] Подробно описаны ожидания эксперимента (какие метрики улучшаем)',
    (u'[Менеджер] Перед включением эксперимента в проде необходимо согласовать его включение или '
     u'НЕвключение на staff с shibanov@ и уведомить в тикете'
     ),
    u'[Менеджер] В случае ограничения эксперимента по бренду/локали необходимо получить "ОК" от shibanov@',
    (u'[Менеджер] Согласовать с руководителем платформы (@shibanov) включение или не включение '
     u'фичи на корпах (sberbank, corporate, mos, rzd)'
     ),
    u'[Отв. разработчик] В бете отсутствуют (или имеют очень низкую частотность) специфичные крэши ',
    u'[Отв. разработчик] Проведены перф-тесты фичи, ссылка на результаты прогона приложена в тикет',
)

_DEBRO_FEATURE_TOGGLE_PRODUCTION = (
    u'[Менеджер] Получен аппрув руководителя платформы (@shibanov) на раскатку на 100%.',
    u'[Менеджер] Эксперимент в стейбле проверен и окнут аналитиками.',
    u'[Отв. тестировщик] Фича имеет достаточное качества для раскатки на 100% (отсутствуют криты и ЗБП)',
    u'[Отв. разработчик] В стейбле отсутствуют (или имеют очень низкую частотность) специфичные крэши',
)

_GATEWAY_ABT_BETA_ANDROID = (
    u'[Менеджер] Фича включена в canary+nightly',
    u'[Менеджер] К тикету на EXPERIMENTS слинкован основной эпик по фиче (или наиболее релевантный тикет)',
    (u'[Отв. тестировщик] Фича протестирована в версии, в которой будет включаться,'
     u' и имеет достаточное качество для беты'),
    u'[Отв. тестировщик] Изменения в конфиге соответствуют описанию в тикете',
)

_GATEWAY_ABT_PRODUCTION_ANDROID = (
    u'[Менеджер] К тикету на EXPERIMENTS слинкован основной эпик по фиче (или наиболее релевантный тикет)',
    (u'[Менеджер] Если размер аудитории превышает 20% или выборки 5%, то объяснить причину и получить аппрув '
     u'руководителя разработки (@avasilov) или руководителя платформы (@nikgv).'),
    (u'[Менеджер] Если планируется увеличение аудитории эксперимента, необходимо предусмотреть резервные слоты '
     u'между группами (призвать релиз менеджера) сделать рассылку'),
    u'[Отв. тестировщик] Фича прошла катофф в версии, в которой планируется запуск эксперимента',
    u'[Отв. тестировщик] Добавлены скриншоты/видео работы фичи (было/стало)',
    u'[Отв. тестировщик] Изменения в конфиге соответствуют описанию в тикете',
    (u'[Отв. тестировщик] Фича запущена в бете в той же конфигурации (в случае отличия в тикете нужен аппрув '
     u'руководителя разработки (@avasilov) или руководителя платформы (@nikgv)).'),
    u'[Отв. тестировщик] В бете фича запущена минимум сутки для сбора проблем и крешей.',
    u'[Отв. разработчик] В бете отсутствуют (или имеют очень низкую частотность) специфичные крэши',
    u'[Менеджер] Подробно описаны ожидания эксперимента (какие метрики улучшаем)',
)

_GATEWAY_ABT_PRODUCTION_IOS_INTERNAL = (
    u'[Менеджер] К тикету на EXPERIMENTS слинкован основной эпик по фиче (или наиболее релевантный тикет)',
    u'[Менеджер] Фича была показана на смотре',
    (u'[Менеджер] Получить аппрув руководителя платформы (@shlyamov/@alexeydrozdov) на запуск экспа, '
     u'для технического экспа достаточно ОК от @pavor'),
    u'[Тестировщик] Для визуальных фич добавлены скриншоты/видео работы фичи (было/стало)',
    u'[Тестировщик] В таблице эксперимента Network – internal network',
)

_GATEWAY_ABT_PRODUCTION_IOS_EXTERNAL = (
    u'[Менеджер] Подробно описаны ожидания эксперимента (какие метрики улучшаем).',
    u'[Менеджер] Запущен эксперимент на бету и стаф',
    u'[Менеджер] К тикету на EXPERIMENTS слинкован основной эпик по фиче (или наиболее релевантный тикет)',
    (u'[Менеджер] Если размер аудитории превышает 50% или выборки 20%, то объяснить причину и получить аппрув '
     u'руководителя разработки (@pavor) или руководителя платформы (@shlyamov/@alexeydrozdov)'),
    (u'[Менеджер] Получить аппрув руководителя платформы (@shlyamov/@alexeydrozdov) на запуск экспа, '
     u'для технического экспа достаточно ОК от @pavor'),
    u'[Тестировщик] Фича удовлетворяет таргетам по ZBP',
    u'[Тестировщик] Для визуальных фич добавлены скриншоты/видео работы фичи (было/стало)',
    u'[Тестировщик] В бете и стафф фича запущена минимум сутки для сбора проблем и крешей',
    u'[Отв. разработчик] В бете и стаф отсутствуют (или имеют очень низкую частотность) специфичные крэши',
)


_GATEWAY_ABT_BETTA_IOS = (
    u'[Менеджер] К тикету на EXPERIMENTS слинкован основной эпик по фиче (или наиболее релевантный тикет)',
    u'[Менеджер] Фича была показана на смотре',
    (u'[Менеджер] Получить аппрув руководителя платформы (@shlyamov/@alexeydrozdov) на запуск экспа, '
     u'для технического экспа достаточно ОК от @pavor'),
    u'[Тестировщик] Для визуальных фич добавлены скриншоты/видео работы фичи (было/стало)',
    u'[Тестировщик] В таблице эксперимента Build types: alpha, beta',
    u'[Отв. разработчик] Фича включена по дефолту в Canary на финальном этапе разработки перед экспериментом',
)

_BROWSER_ABT_ALPHA_BETTA = (
    u'[Отв. разработчик] Фича включена в canary+broteam',
    u'[Менеджер] К тикету на EXPERIMENTS слинкован основной эпик по фиче (или наиболее релевантный тикет)',
    u'[Отв. тестировщик] Фича протестирована в версии, в которой будет включаться, и имеет достаточное качество для альфы/беты',
    u'[Отв. тестировщик] Изменения в конфиге соответствуют описанию в тикете',
)

_BROWSER_ABT_PRODUCTION = (
    u'[Менеджер] К тикету на EXPERIMENTS слинкован основной эпик по фиче (или наиболее релевантный тикет)',
    (u'[Менеджер] Если размер аудитории превышает 5%, то объяснить причину и получить аппрув руководителя разработки '
     u'(@avasilov) или руководителя платформы (@nikgv)'),
    u'[Менеджер] Если планируется увеличение аудитории эксперимента, необходимо предусмотреть резервные слоты между группами',
    u'[Отв. тестировщик] Фича прошла катофф в версии, в которой планируется запуск эксперимента',
    u'[Отв. тестировщик] Добавлены скриншоты/видео работы фичи (было/стало)',
    u'[Отв. тестировщик] Изменения в конфиге соответствуют описанию в тикете',
    (u'[Отв. тестировщик] Фича запущена в бете в той же конфигурации (в случае отличия в тикете нужен аппрув '
     u'руководителя разработки (@avasilov) или руководителя платформы (@nikgv))'),
    u'[Отв. тестировщик] В бете фича запущена минимум сутки для сбора проблем и крешей',
    u'[Отв. разработчик] В альфе/бете отсутствуют (или имеют очень низкую частотность) специфичные крэши',
    u'[Менеджер] Подробно описаны ожидания эксперимента (какие метрики улучшаем)',
)

_DEBRO_CHECKLISTS = {
    ('ABT', Channel.BROTEAM, _ANY, _ANY): _DEBRO_ABT_DEV,
    ('ABT', Channel.BETA, _ANY, _ANY): _DEBRO_ABT_BETA,
    ('ABT', Channel.STABLE, _ANY, _ANY): _DEBRO_ABT_PRODUCTION,
    ('FEATURE_TOGGLE', Channel.STABLE, _ANY, _ANY): _DEBRO_FEATURE_TOGGLE_PRODUCTION,
}

_GATEWAY_CHECKLISTS = {
    ('ABT', Channel.BETA, 'android', _ANY): _GATEWAY_ABT_BETA_ANDROID,
    ('ABT', Channel.STABLE, 'android', _ANY): _GATEWAY_ABT_PRODUCTION_ANDROID,
    ('ABT', Channel.STABLE, 'ios', 'internal'): _GATEWAY_ABT_PRODUCTION_IOS_INTERNAL,
    ('ABT', Channel.STABLE, 'ios', 'external'): _GATEWAY_ABT_PRODUCTION_IOS_EXTERNAL,
    ('ABT', Channel.STABLE, 'ios', ''): _GATEWAY_ABT_PRODUCTION_IOS_EXTERNAL,
    ('ABT', Channel.BETA, 'ios', _ANY): _GATEWAY_ABT_BETTA_IOS,
}

_BROWSER_CHECKLISTS = {
    ('ABT', Channel.BETA, 'android', _ANY): _BROWSER_ABT_ALPHA_BETTA,
    ('ABT', Channel.ALPHA, 'android', _ANY): _BROWSER_ABT_ALPHA_BETTA,
    ('ABT', Channel.STABLE, 'android', _ANY): _BROWSER_ABT_PRODUCTION,
}


_CHECKLISTS_BY_AB_QUEUE = {
    Queue.DEBRO: _DEBRO_CHECKLISTS,
    Queue.BROWSER: _BROWSER_CHECKLISTS,
    Queue.GATEWAY: _GATEWAY_CHECKLISTS,
}


def build_actual_checklist(cur_checklist, queue, exp_info):
    """
    :type cur_checklist: list[ChecklistItem]
    :type queue: Queue
    :type exp_info: list[tuple[str, Channel, str, str]]
    :rtype: list[ChecklistItem]
    """
    regular_checklist_items = _get_regular_checklist_items(queue)
    actual_checklists = tuple(
        _get_actual_checklist(queue, exp_param)
        for exp_param in exp_info
    )

    checked_regular_checklist_items = [
        item.text for item in cur_checklist
        if item.checked and item.text in regular_checklist_items
    ]
    custom_checklist_items = [
        item.text for item in cur_checklist
        if item.text not in regular_checklist_items
    ]

    checklists_to_merge = actual_checklists + (checked_regular_checklist_items, custom_checklist_items)
    checklists_to_merge = list(filter(None, checklists_to_merge))

    checked_items = {item.text for item in cur_checklist if item.checked}
    merged_checklist = util.merge_checklists(
        checklists=checklists_to_merge,
        checked_items=checked_items,
    )
    return [
        ChecklistItem(text=item, checked=item in checked_items)
        for item in merged_checklist
    ]


def _get_actual_checklist(queue, exp_param):
    """
    :type queue: Queue
    :type exp_info: tuple[str, Channel, str, str]
    :rtype: list[str]
    """
    if queue not in _CHECKLISTS_BY_AB_QUEUE:
        return []

    queue_checklists = _CHECKLISTS_BY_AB_QUEUE[queue]
    for key, checklist in queue_checklists.items():
        if exp_param == key:
            return list(checklist)
    return []


def _get_regular_checklist_items(queue):
    """
    :type queue: Queue
    :rtype: set[str]
    """
    checklists = tuple(map(set, _CHECKLISTS_BY_AB_QUEUE.get(queue, {}).values()))
    return set.union(*checklists) if checklists else set()
