# -*- encoding: utf-8 -*-
import logging
import textwrap

import requests

from sandbox import sdk2

from sandbox.projects.browser.ab_experiments import base


class BrowserExperimentsAbNotificationTask(base.BaseAbTask):
    # https://yndx-browser.slack.com/services/2309628118945
    HOOK_URL = 'https://hooks.slack.com/services/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'
    MESSAGE_PTTRN = textwrap.dedent(u"""\
        *{queue}*
        Заведен новый эксперимент. <https://ab.yandex-team.ru/task/{task_id}|{task_id}>.
        `{description}`""")

    class Parameters(base.AbTaskParameters):
        state_prev = sdk2.parameters.String('Previous state')
        state_cur = sdk2.parameters.String('Current state')

    def _on_execute(self):
        super(BrowserExperimentsAbNotificationTask, self)._on_execute()

        msg = self.MESSAGE_PTTRN.format(queue=self.ab_task_queue.name,
                                        task_id=self.ab_task_id,
                                        description=self.ab_task_info['title'])
        if self.Parameters.dry_run:
            logging.info(u'Skip sending message "%s" to %s because of dry run mode',
                         msg, self.HOOK_URL)
        else:
            requests.post(self.HOOK_URL, json={'text': msg, 'type': 'mrkdwn'})
