# -*- coding: utf-8 -*-
import enum


@enum.unique
class Channel(enum.Enum):
    BROTEAM = 0  # Бротим
    ALPHA = 1  # Альфа
    BETA = 2  # Бета
    STABLE = 3  # Выкатка фичи в эксперимент


_CHANNEL_BY_AB_CHANNEL = {
    'dev': Channel.BROTEAM,
    'alpha': Channel.ALPHA,
    'beta': Channel.BETA,
    'production': Channel.STABLE,
}


def get_channel_by_ab_channel(ab_channel):
    """
    :type ab_channel: Literal['dev', 'beta', 'production'] or str
    :rtype: Channel or None
    """
    if ab_channel in _CHANNEL_BY_AB_CHANNEL:
        return _CHANNEL_BY_AB_CHANNEL[ab_channel]
    return None
