# coding=utf-8
import os

from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.projects.browser.autotests import AlicekitAssessorsLaunch as local_script
from sandbox.projects.browser.autotests_qa_tools.common import ROBOT_BRO_QA_INFRA_TOKEN_VAULT, html_link


class AlicekitAssessorsLaunch(sdk2.Task):
    class Parameters(sdk2.Parameters):
        with sdk2.parameters.String("Platform") as platform:
            platform.values.Android = platform.Value("Android")
            platform.values.iOS = platform.Value("iOS")
        major_version = sdk2.parameters.Integer('Major version', required=True)
        minor_version = sdk2.parameters.Integer('Minor version', required=True)
        test_launch = sdk2.parameters.Bool(
            'Test lauch', description='if true, then only small amount of runs will be created '
                                      'and version name will have "TEST_SCRIPT" prefix')

    class Requirements(sdk2.Task.Requirements):
        disk_space = 150
        cores = 1
        client_tags = ctc.Tag.Group.LINUX & ctc.Tag.BROWSER

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        os.environ['TESTPALM_TOKEN'] = sdk2.Vault.data(ROBOT_BRO_QA_INFRA_TOKEN_VAULT)
        betamsoft, url_hitman, link_to_version = local_script.run(
            self.Parameters.platform,
            self.Parameters.major_version,
            self.Parameters.minor_version,
            self.Parameters.test_launch
        )
        self.set_info(
            'Link to beta: {}<br/>Link to hitman: {}<br/>Link to created version: {}'.format(
                html_link(betamsoft),
                html_link(url_hitman),
                html_link(link_to_version)
            ),
            do_escape=False,
        )
