#!/usr/bin/python
# -*- coding: UTF-8 -*-
import requests
import os
import urllib3

urllib3.disable_warnings()


def headers(type_accept):
    return (
        {
            "Accept": type_accept,
            "Content-Type": "application/json;charset=utf-8",
            "Authorization": "OAuth {}".format(os.environ['TESTPALM_TOKEN'])
        }
    )


def sendRequestPost(url_request, date_request, type_accept):
    send_requests = requests.post(url_request, json=date_request, headers=headers(type_accept), verify=False)
    print(send_requests.text)
    send_requests.raise_for_status()


def sendRequestPut(url_request, date_request, type_accept):
    send_requests = requests.put(url_request, json=date_request, headers=headers(type_accept), verify=False)
    print(send_requests.text)
    send_requests.raise_for_status()


def createVersion(version_name):
    url_create_version = 'https://testpalm-api.yandex-team.ru/version/alicekit'
    data_create_version = ({
        "id": str(version_name),
        "title": str(version_name),
        "status": "STARTED",
        "archived": False
    })
    sendRequestPost(url_create_version, data_create_version, "application/json")
    return 'https://testpalm.yandex-team.ru/alicekit/version/{}'.format(version_name)


def createRun(run_id, name, run_version, forFarm, version_name):
    tag = []
    if forFarm:
        tag = ["notSuitableForFarm"]
    data_create_run = ({
        "title": name,
        "version": version_name,
        "launcherInfo": {
            "external": False,
            "internalExecAllowed": False
        },
        "internalResolveAllowed": False,
        "currentEnvironment": {
            "title": run_version,
            "default": False
        },
        "tags": tag,
        "archived": False,
        "testSuite": {
            "id": run_id
        }
    })

    url_create_run = 'https://testpalm-api.yandex-team.ru/testrun/alicekit/create/'
    sendRequestPost(url_create_run, data_create_run, 'application/json')


def createGroupRuns(run_json, device_type, platform, version_name):
    if platform == "Android":
        version = run_json["min_version_android"]
        max_version = run_json["max_version_android"]
    else:
        version = run_json["min_version_ios"]
        max_version = run_json["max_version_ios"]

    while version <= max_version:
        if platform == "iOS":
            run_version = platform + " " + str(version) + " " + device_type
        else:
            run_version = platform + " " + str(version) + ".x.x " + device_type
        createRun(run_json["run_id"], run_json["name"], run_version, run_json["notSuitableForFarm"], version_name)
        version = version + 1


def startCreateRuns(platform, runs_info, version_name, test_launch):
    if test_launch:
        runs_info = runs_info[0:1]
    for run_info in runs_info:
        if run_info["platform"] in (platform, "all"):
            if run_info["device_type"] in ("Smart", "all"):
                createGroupRuns(run_info, "Smart", platform, version_name)
            else:
                createGroupRuns(run_info, "Pad", platform, version_name)


def changeHitmansParameter(parameter_id, parameter_value, parameter_name):
    url_change_hitmans_parametr = 'https://hitman.yandex-team.ru/front/processes/alicekit_test/workflow/properties/'
    data_hitmans_parameter = {
        "localBlockId": "Global",
        "valueType": "CONST",
        "name": parameter_name,
        "value": parameter_value,
        "propertyId": parameter_id
    }
    url = url_change_hitmans_parametr + parameter_id
    sendRequestPut(url, data_hitmans_parameter, "application/json")


def changeInHitman(hitman_settings, platform, version_name, betamsoft):
    for hit in hitman_settings:
        if hit["platform"] in (platform, "all"):
            if hit["name"] == "version":
                changeHitmansParameter(hit["propertyId"], version_name, "version")
            elif hit["name"] == "test_stend":
                changeHitmansParameter(hit["propertyId"], betamsoft, "test_stend")


def run(platform, major_version, minor_version, test_launch=False):
    runs = requests.get('http://alicekit.s3.yandex.net/testpalm/runs_for_assessors.json').json()
    url_hitman = 'https://hitman.yandex-team.ru/projects/testing_alicekit/testing_alicekit'
    url_betamsoft = 'https://beta.m.soft.yandex.ru/description?app=alicekit&platform_shortcut='

    if platform not in ['iOS', 'Android']:
        raise Exception('wrong platform {}'.format(platform))

    number_version_test_palm = str(major_version) + "." + str(minor_version)

    if platform == "Android":
        version_name = "android_assessors_" + number_version_test_palm
        betamsoft = url_betamsoft + 'android&branch=R-' + str(major_version)
    else:
        version_name = "ios_assessors_" + number_version_test_palm
        betamsoft = url_betamsoft + 'iphoneos&branch=release-' + str(major_version) + "00"
        url_hitman = url_hitman + "_iOS"

    if test_launch:
        version_name = 'TEST_SCRIPT_LAUNCH_' + version_name

    link_to_version = createVersion(version_name)
    startCreateRuns(platform, runs, version_name, test_launch)
    # hitman_settings = requests.get('http://alicekit.s3.yandex.net/testpalm/hitman_settings.json').json()
    # changeInHitman(hitman_settings, platform, version_name, betamsoft)
    return betamsoft, url_hitman, link_to_version
