"""
Author: Olga Kochetova <myxomopla@yandex-team.ru>
"""

from sandbox.projects.browser.autotests.BrowserAutotestsTask import BrowserAutotestsTask, TEAMCITY_AUTOTESTS_POOLS, \
    MAIN_MAC_FLAVOUR
from sandbox import sdk2

TEAMCITY_BUILDS = {
    'win': 'Browser_Tests_Functional_Screenshots_Win7x64',
    'mac': 'Browser_Tests_Functional_Screenshots_Mac',
}

TEAMCITY_POOLS = {
    'win': TEAMCITY_AUTOTESTS_POOLS['win7_x64'],
    'mac': TEAMCITY_AUTOTESTS_POOLS[MAIN_MAC_FLAVOUR],
}


DISTRIBUTIONS_MAP = {'partner': 'partners',
                     'brand': 'brands'}

PREDEFINED_SETUPS = {
    'beta': {"full_check": [{"name": "beta-custo", "type": "partner", "lang": "ru"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "en"},
                            {"name": "beta-custo-tb", "type": "partner", "lang": "tr"},
                            {"name": "beta-custo-uaru", "type": "partner", "region": "uk", "lang": "ru"},
                            {"name": "beta-custo-uauk", "type": "partner", "lang": "uk"},
                            {"name": "beta-public", "type": "partner", "lang": "ru"}],
             "lang_check": [{"name": "beta-custo-int", "type": "partner", "lang": "pt-br"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "ja"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "zh-TW"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "zh-CN"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "en"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "ru"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "tr"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "uk"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "es"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "it"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "de"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "pt-PT"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "fr"},
                            {"name": "beta-custo-int", "type": "partner", "lang": "cs"}]},
    'rc': {"full_check": [{"name": "by", "type": "brand", "lang": "by"},
                          {"name": "int", "type": "brand", "lang": "en"},
                          {"name": "tb", "type": "brand", "lang": "tr"},
                          {"name": "ua-ru", "type": "brand", "region": "uk", "lang": "ru"},
                          {"name": "ua-uk", "type": "brand", "lang": "uk"},
                          {"name": "yandex", "type": "brand", "lang": "ru"}],
           "lang_check": [{"name": "int", "type": "brand", "lang": "pt-br"},
                          {"name": "int", "type": "brand", "lang": "ja"},
                          {"name": "int", "type": "brand", "lang": "zh-TW"},
                          {"name": "int", "type": "brand", "lang": "zh-CN"},
                          {"name": "int", "type": "brand", "lang": "en"},
                          {"name": "int", "type": "brand", "lang": "ru"},
                          {"name": "int", "type": "brand", "lang": "tr"},
                          {"name": "int", "type": "brand", "lang": "uk"},
                          {"name": "int", "type": "brand", "lang": "es"},
                          {"name": "int", "type": "brand", "lang": "it"},
                          {"name": "int", "type": "brand", "lang": "de"},
                          {"name": "int", "type": "brand", "lang": "pt-PT"},
                          {"name": "int", "type": "brand", "lang": "fr"},
                          {"name": "int", "type": "brand", "lang": "cs"}]},
    'partners': {"short_check": [{"all": True, "type": "partner"}]}
}


class BrowserAutotestRunScreentool(BrowserAutotestsTask):
    class Parameters(BrowserAutotestsTask.Parameters):
        build_id = sdk2.parameters.Integer('Browser build id')
        platform = sdk2.parameters.String('Platform', choices=[(_, _) for _ in ['win', 'mac']],
                                          default='win', required=True)
        setup_type = sdk2.parameters.String('Setup type.',
                                            description='Choose one of predefined setups.'
                                                        ' Or choose "custom" and provide setup'
                                                        ' "Custom setup" parameter', required=True,
                                            choices=[(_, _) for _ in PREDEFINED_SETUPS.keys() + ['custom']],
                                            default='custom')
        with setup_type.value["custom"]:
            custom_setup = sdk2.parameters.JSON(
                'Custom setup', description='Json with test launch parameters. See schema '
                                            '<a href=https://bitbucket.browser.yandex-team.ru/projects/AUTOTEST/'
                                            'repos/browser-test-framework/browse/'
                                            'yatest_framework/tools/distribution/schema.json> here</a>',
                default={"full_check": [
                    {"name": "by", "type": "brand", "lang": "by"},
                    {"name": "ua-ru", "type": "brand", "region": "uk", "lang": "ru"}]})

    class Context(BrowserAutotestsTask.Context):
        download_xml_reports = False

    def get_teamcity_builds_to_launch(self):
        def get_build_launch_info(screen_type, distribution_name,
                                  distribution_type, region, lang):
            run_name = '{}.{}.{}.{}.{}'.format(distribution_type, distribution_name,
                                               screen_type, region, lang)
            params = {
                'screen_type': screen_type,
                'distribution_name': distribution_name,
                'distribution_type': distribution_type,
                'region': region,
                'language': lang,
                'build_id': self.Parameters.build_id,
            }
            return run_name, params

        res = {}
        if self.Parameters.setup_type == 'custom':
            setup = self.Parameters.custom_setup
        else:
            setup = PREDEFINED_SETUPS[self.Parameters.setup_type]

        for screen_type, distributions in setup.iteritems():
            for distribution in distributions:
                if distribution.get('all'):
                    build = self.teamcity_client.rest_api.builds.locator(id=self.Parameters.build_id)
                    artifacts = build.artifacts[DISTRIBUTIONS_MAP[distribution['type']]].get().file
                    for artifact in artifacts:
                        run_name, params = get_build_launch_info(
                            screen_type=screen_type,
                            distribution_name=artifact['name'],
                            distribution_type=distribution['type'],
                            region=distribution.get('region', distribution.get('lang', 'ru')),
                            lang=distribution.get('lang', 'ru')
                        )
                        res[run_name] = (TEAMCITY_BUILDS[self.Parameters.platform],
                                         TEAMCITY_POOLS[self.Parameters.platform], params)

                else:
                    run_name, params = get_build_launch_info(
                        screen_type=screen_type,
                        distribution_name=distribution['name'],
                        distribution_type=distribution['type'],
                        region=distribution.get('region', distribution.get('lang', 'ru')),
                        lang=distribution.get('lang', 'ru')
                    )
                    res[run_name] = (TEAMCITY_BUILDS[self.Parameters.platform],
                                     TEAMCITY_POOLS[self.Parameters.platform], params)
        return res
