# -*- coding: utf-8 -*-
from sandbox.projects.browser.autotests.BrowserAutotestTestpalmExport import (
    ROBOT_USERAGENT, ST_BASE_API_URL, TESTPALM_API_HOST, TESTPALM_PROJECT, report_to_testpalm)
from sandbox.projects.browser.autotests.BrowserAutotestTestpalmExport.const import TESTSUITES_WIN, TESTSUITES_MAC
from sandbox.projects.browser.autotests_qa_tools.common import ROBOT_BRO_QA_INFRA_TOKEN_VAULT
from sandbox.projects.browser.autotests_qa_tools.sb_common.resources import AutotestsAllureData
from sandbox import common
from sandbox import sdk2
from sandbox.common.types.task import Status
from sandbox.common.types import notification as ctn
from sandbox.sandboxsdk.environments import PipEnvironment


class BrowserAutotestTestpalmExport(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        # disk_space = 1000
        environments = [
            PipEnvironment('testpalm-api-client', version='4.0.2'),
            PipEnvironment('startrek_client', version='1.7.0', use_wheel=True),
        ]

    class Parameters(sdk2.Parameters):
        notifications = (
            sdk2.Notification(
                [Status.FAILURE, Status.Group.BREAK],
                ['browser-autotests-bots'],
                ctn.Transport.EMAIL
            )
        )
        allure_report = sdk2.parameters.Resource('Allure report', required=True, resource_type=AutotestsAllureData)
        regression_issue = sdk2.parameters.String('Regression issue', required=True)
        group_issues = sdk2.parameters.Dict('Groups issues')
        platform = sdk2.parameters.String('Platform', required=True, choices=[(_, _) for _ in ['win', 'mac']],
                                          default='win')
        browser_version = sdk2.parameters.String('Browser version', required=True)
        build_url = sdk2.parameters.String('Browser build url', required=True)
        after_autotests_suites = sdk2.parameters.JSON(
            'After autotests suites',
            default={
                'win': TESTSUITES_WIN,
                'mac': TESTSUITES_MAC,
            })

        with sdk2.parameters.Group('Credentials') as credentials_group:
            oauth_vault = sdk2.parameters.String('Vault item with token for st and testpalm',
                                                 default=ROBOT_BRO_QA_INFRA_TOKEN_VAULT)

    class Context(sdk2.Context):
        testruns = []
        testruns_updated = False
        comment_text = ''

    @property
    @common.utils.singleton
    def startrek_client(self):
        from startrek_client import Startrek
        return Startrek(useragent=ROBOT_USERAGENT,
                        token=sdk2.Vault.data(self.Parameters.oauth_vault),
                        base_url=ST_BASE_API_URL)

    @property
    @common.utils.singleton
    def testpalm_client(self):
        from testpalm_api_client.client import TestPalmClient
        return TestPalmClient(host=TESTPALM_API_HOST,
                              oauth_token=sdk2.Vault.data(self.Parameters.oauth_vault),
                              project=TESTPALM_PROJECT)

    def on_execute(self):
        self.Context.allure_report_path = str(sdk2.ResourceData(self.Parameters.allure_report).path)
        report_to_testpalm(self)
