from enum import Enum


class BRANDS(Enum):
    yandex = "yandex"


class CONFIGURATIONS(Enum):
    win7x64 = ("Windows 7 64bit", True)
    win7x32 = ("Windows 7 32bit", False)
    win8x64 = ("Windows 8.1 64bit", False)
    win10x64 = ("Windows 10 64bit", False)
    macos10_10 = ("MacOS 10.10 64bit", False)
    macos10_11 = ("MacOS 10.11 64bit", False)
    macos10_12 = ("MacOS 10.12 64bit", False)
    macos10_13 = ("MacOS 10.13 64bit", True)

    def __init__(self, configuration, is_platform_main):
        self.configuration = configuration
        self.is_platform_main = is_platform_main


def is_configuration_main(configuration_value):
    for configuration in CONFIGURATIONS:
        if configuration.configuration == configuration_value:
            return configuration.is_platform_main


class TESTCASE_STATUSES(Enum):
    passed = 'PASSED'
    skipped = 'SKIPPED'
    failed = 'FAILED'
    created = 'CREATED'


TESTSUITES_WIN = [
    #     Win
    {"testsuite_id": "5950f4bb88955039afcd754e", 'os': CONFIGURATIONS.win7x64.configuration,
     'brand': BRANDS.yandex.value},
    {"testsuite_id": "5950f6bfc612333cf177b7e8", 'os': CONFIGURATIONS.win7x32.configuration,
     'brand': BRANDS.yandex.value},
    {"testsuite_id": "5950f67d88955039afcd77ac", 'os': CONFIGURATIONS.win8x64.configuration,
     'brand': BRANDS.yandex.value},
    {"testsuite_id": "5950f71988955039afcd77db", 'os': CONFIGURATIONS.win10x64.configuration,
     'brand': BRANDS.yandex.value},
    #     Win-binary tests, see https://st.yandex-team.ru/BYIN-5509
    {'testsuite_id': '5c223af4d477410acf828de5', 'os': CONFIGURATIONS.win7x64.configuration,
     'brand': BRANDS.yandex.value, 'part': 1},  # win7x64 part1
    {'testsuite_id': '5c223eba2f6d480c3f7d5f44', 'os': CONFIGURATIONS.win7x32.configuration,
     'brand': BRANDS.yandex.value, 'part': 1},  # win7x32 part1
    {'testsuite_id': '5c223f7b2a786809db615ad6', 'os': CONFIGURATIONS.win8x64.configuration,
     'brand': BRANDS.yandex.value, 'part': 1},  # win8x64 part1
    {'testsuite_id': '5c2240022a786809db615f60', 'os': CONFIGURATIONS.win10x64.configuration,
     'brand': BRANDS.yandex.value, 'part': 1},  # win8x64 part1
    #    Win-bynary from other projects, see https://st.yandex-team.ru/BYIN-6756
    # [BroTest][Done][Partly][ZenLib] Automated [yandex][win7x64] https://testpalm.yandex-team.ru/zenlib_browser/testsuite/5cf0d6a6856d2d0a1bcd7a52
    {"testsuite_id": "5cf0d6a6856d2d0a1bcd7a52", "project_id": "zenlib_browser",
     'os': CONFIGURATIONS.win7x64.configuration, 'brand': BRANDS.yandex.value},
    # [BroTest][Done][Partly][ZenLib] Automated [yandex][win7x32] https://testpalm.yandex-team.ru/zenlib_browser/testsuite/5cf0d8df23d98a0b45bdc5cf
    {"testsuite_id": "5cf0d8df23d98a0b45bdc5cf", "project_id": "zenlib_browser",
     'os': CONFIGURATIONS.win7x32.configuration, 'brand': BRANDS.yandex.value},
    # [BroTest][Done][Partly][ZenLib] Automated [yandex][win81x64] https://testpalm.yandex-team.ru/zenlib_browser/testsuite/5cf0d792856d2d0a1bcd7a77
    {"testsuite_id": "5cf0d792856d2d0a1bcd7a77", "project_id": "zenlib_browser",
     'os': CONFIGURATIONS.win8x64.configuration, 'brand': BRANDS.yandex.value},
    # [BroTest][Done][Partly][ZenLib] Automated [yandex][win10x64] https://testpalm.yandex-team.ru/zenlib_browser/testsuite/5cf0d655ee4f430be5ea63dd
    {"testsuite_id": "5cf0d655ee4f430be5ea63dd", "project_id": "zenlib_browser",
     'os': CONFIGURATIONS.win10x64.configuration, 'brand': BRANDS.yandex.value},
]

TESTSUITES_MAC = [
    # #  mac
    {"testsuite_id": "5952248788955039afcdc6cc", 'os': CONFIGURATIONS.macos10_13.configuration,
     'brand': BRANDS.yandex.value},
    {"testsuite_id": "5be2d94c79863336a06bf589", 'os': CONFIGURATIONS.macos10_12.configuration,
     'brand': BRANDS.yandex.value},

    # mac binary tests, see https://st.yandex-team.ru/BYIN-5509
    {"testsuite_id": "5c38a00e2a7868055632c3ed", 'os': CONFIGURATIONS.macos10_13.configuration,
     'brand': BRANDS.yandex.value, 'part': 1},

    #    Mac-bynary from other projects, see https://st.yandex-team.ru/BYIN-6756
    # [BroTest][Done][Partly][ZenLib] Automated [yandex][MAC 10.13] https://testpalm.yandex-team.ru/zenlib_browser/testsuite/5cf0d7c6ee4f430be5ea6464
    {"testsuite_id": "5cf0d7c6ee4f430be5ea6464", "project_id": "zenlib_browser",
     'os': CONFIGURATIONS.macos10_13.configuration, 'brand': BRANDS.yandex.value},
]
