import argparse
import json

import os

from sandbox import common
from sandbox.projects.browser.autotests.BrowserAutotestTestpalmExport import (
    TESTPALM_API_HOST, TESTPALM_PROJECT, ST_BASE_API_URL, ROBOT_USERAGENT, report_to_testpalm)
from sandbox.projects.browser.autotests.BrowserAutotestTestpalmExport.const import TESTSUITES_WIN, TESTSUITES_MAC


class LocalRunner(object):
    class Parameters(object):
        regression_issue = ''
        platform = ''
        browser_version = ''
        build_url = ''
        group_issues = {}

    class Context(object):
        testruns = {}
        testruns_updated = False
        comment_text = ''
        allure_report_path = ''
        testruns_with_testcases = {}

    @property
    @common.utils.singleton
    def startrek_client(self):
        from startrek_client import Startrek
        return Startrek(useragent=ROBOT_USERAGENT,
                        token=os.environ[self.options.st_token_env],
                        base_url=ST_BASE_API_URL)

    @property
    @common.utils.singleton
    def testpalm_client(self):
        from testpalm_api_client.client import TestPalmClient
        return TestPalmClient(host=TESTPALM_API_HOST,
                              oauth_token=os.environ[self.options.testpalm_token_env],
                              project=TESTPALM_PROJECT)

    def _parse_args(self):
        parser = argparse.ArgumentParser()
        parser.add_argument('--allure-report', default='allure-report/data',
                            dest='allure_report_folder',
                            help='Path to folder for allure-report data')
        parser.add_argument('--platform', default=None, dest='platform',
                            help='Browser platform: win or mac')
        parser.add_argument('--browser-version', default=None, dest='browser_version',
                            help='Browser version. For example 17.7.0')
        parser.add_argument('--issue', default=None, dest='issue',
                            help='Startrack issue key. For example BROWSER-51345')
        parser.add_argument('--build-url', default=None, dest='build_url',
                            help='Browser build url.')
        parser.add_argument('--st-token-env', default=None, dest='st_token_env',
                            help='Environment variable with startrek token')
        parser.add_argument('--testpalm-token-env', default=None,
                            dest='testpalm_token_env',
                            help='Environment variable with testpalm token')
        parser.add_argument('--group-issues', default="{}", dest='group_issues',
                            help='{group_name: issue_key}'),
        parser.add_argument('--after_autotests_suites', default=json.dumps({'win': TESTSUITES_WIN, 'mac': TESTSUITES_MAC}), dest='after_autotests_suites')

        self.options = parser.parse_args()

    def __init__(self):
        self._parse_args()
        self.Parameters.regression_issue = self.options.issue
        self.Parameters.platform = self.options.platform
        self.Parameters.browser_version = self.options.browser_version
        self.Parameters.build_url = self.options.build_url
        self.Parameters.group_issues = json.loads(self.options.group_issues)
        self.Parameters.after_autotests_suites = json.loads(self.options.after_autotests_suites)
        self.Context.allure_report_path = self.options.allure_report_folder


if __name__ == '__main__':
    report_to_testpalm(LocalRunner())
