const STARCASES_NOT_NEEDED_TAG = 'StarCasesNotNeed';
const STARCASES_DONE_TAG = 'StarCasesDone';


function request(method, theUrl, body) {
    var xmlHttp = new XMLHttpRequest();
    xmlHttp.withCredentials = true;
    xmlHttp.open(method, theUrl, false); // false for synchronous request
    xmlHttp.send(body);
    return xmlHttp.responseText;
}

function getIssueObj(issue_key) {
    return JSON.parse(request('GET', 'https://st-api.yandex-team.ru/v2/issues/' + encodeURI(issue_key)), null);
}

function getIssueKey() {
    return new URLSearchParams(window.location.search).get('issue');
}

function markCheckedFunctionalities() {
    var issue_key = getIssueKey();
    if (issue_key) {
        var issue = getIssueObj(issue_key);
        var functionalities_string = issue['functionality'];
        var tags = issue['tags'];

        try {
            var functionalities_json = JSON.parse(functionalities_string);
        } catch (e) {
            window.alert('Functionalities in issue are not well formatted.' +
                ' Changes from this page will override any info, that functionality field contains.');
            return
        }

        var functionalities = functionalities_json['funcs'];
        for (var i = 0; i < functionalities.length; i++) {
            var functionality = functionalities[i];
            var element = document.getElementById(functionality);
            if (element) {
                element.checked = true;
            }
        }
        if (tags.includes(STARCASES_DONE_TAG) || tags.includes(STARCASES_DONE_TAG)) {
            document.getElementById('last_update').checked = true;
        }
    }
}

function getCheckedFunctionalities() {
    var checkedBoxes = document.querySelectorAll('input[type=checkbox]:checked');
    var functionalities = [];
    for (i = 0; i < checkedBoxes.length; ++i) {
        if (checkedBoxes[i]['name'] !== 'last_update') {
            functionalities.push(checkedBoxes[i]['name'])
        }
    }
    return functionalities
}

function updateFunctionalities() {
    var functionalities = getCheckedFunctionalities();
    var request_json = {};

    if (!functionalities.length) {
        if (document.getElementById('last_update').checked) {
            request_json['tags'] = {"add": [STARCASES_NOT_NEEDED_TAG], "remove": [STARCASES_DONE_TAG]};
            request_json['functionality'] = JSON.stringify({'funcs': []});
        } else {
            window.alert('Nothing is checked, no need to update ticket');
            return
        }
    } else {
        request_json['tags'] = {
            "remove": [STARCASES_NOT_NEEDED_TAG]
        };
        if (document.getElementById('last_update').checked) {
            request_json['tags']['add'] = [STARCASES_DONE_TAG];
        }
        request_json['functionality'] = JSON.stringify({"funcs": functionalities});
    }


    request('PATCH', 'https://st-api.yandex-team.ru/v2/issues/' + encodeURI(getIssueKey()),
        JSON.stringify(request_json));
    window.alert('Updated issue with funcs: ' + (request_json['functionality'] || []) +
        ' and tags: ' + JSON.stringify(request_json['tags'] || [])
    )
}


document.addEventListener("DOMContentLoaded", function (event) {
    markCheckedFunctionalities()
});