# coding=utf-8

import os
from argparse import ArgumentParser


def add_case_to_blacklist(browser_path, test_case_id, config_file, issue_key, yaml):
    config_filepath = os.path.join(browser_path, config_file)
    if not os.path.exists(config_filepath):
        raise RuntimeError(u"Отсутствует файл {}. Тикет {} вероятно не корректен".format(config_file, issue_key))
    with open(config_filepath) as f:
        data = yaml.load(f)

    blacklist = data.get("blacklists", {}) or {}
    case_issues = blacklist.get(test_case_id, "")
    blacklist[test_case_id] = u"{}{}".format(u"{},".format(case_issues) if case_issues else u"",
                                             issue_key)
    data["blacklists"] = blacklist
    with open(config_filepath, 'w') as f:
        yaml.dump(data, f)


def run():
    parser = ArgumentParser()
    parser.add_argument('browser_path'),
    parser.add_argument('test_case_id'),
    parser.add_argument('config_file'),
    parser.add_argument('issue_key'),
    args = parser.parse_args()

    from ruamel.yaml import YAML
    yaml = YAML()
    yaml.indent(mapping=2, sequence=2, offset=2)
    add_case_to_blacklist(args.browser_path, args.test_case_id, args.config_file, args.issue_key, yaml)


if __name__ == '__main__':
    run()
