# -*- coding: utf-8 -*-
import logging
import time

import sandbox
from sandbox.projects.browser.autotests.classes.group_regression_manager.common import GroupRegressionManager, RUN_CREATION_PAUSE
from sandbox.projects.browser.autotests.testpalm_helper import version_url


logger = logging.getLogger(__file__)


class MobileGroupRegressionManager(GroupRegressionManager):

    ticket_jinja_template_package = 'mobile_regression'

    @property
    @sandbox.common.utils.singleton
    def ticket_summary_template(self):
        return u'[{}] Regression Testing релиза {}'.format(self.group.name, self._parameters.version)

    @property
    @sandbox.common.utils.singleton
    def assessors_ticket_summary_template(self):
        return u'[{}][Асессоры] Regression Testing релиза {}'.format(self.group.name, self._parameters.version)

    @property
    @sandbox.common.utils.singleton
    def assessor_version_template(self):
        return u'{}_assessors'.format(self._parameters.version)

    @property
    @sandbox.common.utils.singleton
    def manual_version_template(self):
        return u'{}_manual'.format(self._parameters.version)

    def get_manual_run_title(self, run_template):
        return u'[{} Regression testing][{}] Manual'.format(self._parameters.version,
                                                            run_template["component"])

    def get_assessor_run_title(self, version, run_template):
        return u'[{version} Regression testing][{component}] Assessors. Part {part}'.format(
            version=self._parameters.version,
            part=run_template["part"],
            component=run_template["component"])

    def create_assessor_runs(self, run_temlpates):
        created_runs = []
        for run_template in run_temlpates:
            version = self.get_assessor_version(run_template)
            logger.debug(" ############## asessor_version = {}".format(version))
            run_title = self.get_assessor_run_title(version=version,
                                                    run_template=run_template)

            run_id = self.clients.testpalm.create_testrun(
                version=version,
                cases=self._run_template_2_run_cases_list(run_template["cases"]),
                project=run_template["project"],
                title=run_title,
                properties={},
                current_environment=run_template["environment"],
                tags=run_template["suite_info"]["tags"])

            run_instance = self.clients.testpalm.get_testrun(run_id,
                                                             run_template["project"])
            logger.info("assessors run added: {}".format(run_instance.url))
            created_runs.append({"suite_info": run_template["suite_info"],
                                 "instance": run_instance})
            time.sleep(RUN_CREATION_PAUSE)

        return created_runs

    def render_group_ticket_template(self):
        return self.group_ticket_template.render(
            builds=self._parameters.builds,
            launch_comment=self._parameters.manual_launch_comment
        )

    def render_assessor_ticket_template(self, runs):
        data = dict(
            group=self.group,
            testpalm_versions=set(set(version_url(run["instance"].project,
                                                  run["instance"].version)
                                  for run in runs)),
            builds=self._parameters.builds,
            assessors_launch_comment=self._parameters.assessors_launch_comment)
        return self.assessor_ticket_template.render(**data)
